/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.management;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.credential.CredentialRecordImpl;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.webauthn.api.AttestationConveyancePreference;
import org.springframework.security.web.webauthn.api.AuthenticatorAssertionResponse;
import org.springframework.security.web.webauthn.api.AuthenticatorAttestationResponse;
import org.springframework.security.web.webauthn.api.AuthenticatorSelectionCriteria;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.CredentialRecord;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientInput;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientInputs;
import org.springframework.security.web.webauthn.api.ImmutableCredentialRecord;
import org.springframework.security.web.webauthn.api.ImmutablePublicKeyCose;
import org.springframework.security.web.webauthn.api.ImmutablePublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.api.PublicKeyCredential;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialCreationOptions;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialDescriptor;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialParameters;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRequestOptions;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRpEntity;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.api.ResidentKeyRequirement;
import org.springframework.security.web.webauthn.api.UserVerificationRequirement;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialCreationOptionsRequest;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialRequestOptionsRequest;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialUserEntityRepository;
import org.springframework.security.web.webauthn.management.RelyingPartyAuthenticationRequest;
import org.springframework.security.web.webauthn.management.RelyingPartyPublicKey;
import org.springframework.security.web.webauthn.management.RelyingPartyRegistrationRequest;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.util.Assert;

public class Webauthn4JRelyingPartyOperations
implements WebAuthnRelyingPartyOperations {
    private final PublicKeyCredentialUserEntityRepository userEntities;
    private final UserCredentialRepository userCredentials;
    private final Set<String> allowedOrigins;
    private final PublicKeyCredentialRpEntity rp;
    private final ObjectConverter objectConverter = new ObjectConverter();
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private WebAuthnManager webAuthnManager = WebAuthnManager.createNonStrictWebAuthnManager();
    private Consumer<PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder> customizeCreationOptions = options -> {};
    private Consumer<PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder> customizeRequestOptions = options -> {};

    public Webauthn4JRelyingPartyOperations(PublicKeyCredentialUserEntityRepository userEntities, UserCredentialRepository userCredentials, PublicKeyCredentialRpEntity rpEntity, Set<String> allowedOrigins) {
        Assert.notNull((Object)userEntities, (String)"userEntities cannot be null");
        Assert.notNull((Object)userCredentials, (String)"userCredentials cannot be null");
        Assert.notNull((Object)rpEntity, (String)"rpEntity cannot be null");
        Assert.notNull(allowedOrigins, (String)"allowedOrigins cannot be null");
        this.userEntities = userEntities;
        this.userCredentials = userCredentials;
        this.rp = rpEntity;
        this.allowedOrigins = allowedOrigins;
    }

    public void setWebAuthnManager(WebAuthnManager webAuthnManager) {
        Assert.notNull((Object)webAuthnManager, (String)"webAuthnManager cannot be null");
        this.webAuthnManager = webAuthnManager;
    }

    public void setCustomizeCreationOptions(Consumer<PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder> customizeCreationOptions) {
        Assert.notNull(customizeCreationOptions, (String)"customizeCreationOptions must not be null");
        this.customizeCreationOptions = customizeCreationOptions;
    }

    public void setCustomizeRequestOptions(Consumer<PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder> customizeRequestOptions) {
        Assert.notNull(customizeRequestOptions, (String)"customizeRequestOptions cannot be null");
        this.customizeRequestOptions = customizeRequestOptions;
    }

    @Override
    public PublicKeyCredentialCreationOptions createPublicKeyCredentialCreationOptions(PublicKeyCredentialCreationOptionsRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Authentication authentication = request.getAuthentication();
        if (!this.trustResolver.isAuthenticated(authentication)) {
            throw new IllegalArgumentException("Authentication must be authenticated");
        }
        AuthenticatorSelectionCriteria authenticatorSelection = AuthenticatorSelectionCriteria.builder().userVerification(UserVerificationRequirement.PREFERRED).residentKey(ResidentKeyRequirement.REQUIRED).build();
        ImmutableAuthenticationExtensionsClientInputs clientInputs = new ImmutableAuthenticationExtensionsClientInputs(ImmutableAuthenticationExtensionsClientInput.credProps);
        PublicKeyCredentialUserEntity userEntity = this.findUserEntityOrCreateAndSave(authentication.getName());
        List<CredentialRecord> credentialRecords = this.userCredentials.findByUserId(userEntity.getId());
        PublicKeyCredentialCreationOptions options = PublicKeyCredentialCreationOptions.builder().attestation(AttestationConveyancePreference.NONE).pubKeyCredParams(PublicKeyCredentialParameters.EdDSA, PublicKeyCredentialParameters.ES256, PublicKeyCredentialParameters.RS256).authenticatorSelection(authenticatorSelection).challenge(Bytes.random()).extensions(clientInputs).timeout(Duration.ofMinutes(5L)).user(userEntity).rp(this.rp).excludeCredentials(Webauthn4JRelyingPartyOperations.credentialDescriptors(credentialRecords)).customize(this.customizeCreationOptions).build();
        return options;
    }

    private static List<PublicKeyCredentialDescriptor> credentialDescriptors(List<CredentialRecord> credentialRecords) {
        ArrayList<PublicKeyCredentialDescriptor> result = new ArrayList<PublicKeyCredentialDescriptor>();
        for (CredentialRecord credentialRecord : credentialRecords) {
            Bytes id = Bytes.fromBase64(credentialRecord.getCredentialId().toBase64UrlString());
            PublicKeyCredentialDescriptor credentialDescriptor = PublicKeyCredentialDescriptor.builder().id(id).transports(credentialRecord.getTransports()).build();
            result.add(credentialDescriptor);
        }
        return result;
    }

    private PublicKeyCredentialUserEntity findUserEntityOrCreateAndSave(String username) {
        PublicKeyCredentialUserEntity foundUserEntity = this.userEntities.findByUsername(username);
        if (foundUserEntity != null) {
            return foundUserEntity;
        }
        PublicKeyCredentialUserEntity userEntity = ImmutablePublicKeyCredentialUserEntity.builder().displayName(username).id(Bytes.random()).name(username).build();
        this.userEntities.save(userEntity);
        return userEntity;
    }

    @Override
    public CredentialRecord registerCredential(RelyingPartyRegistrationRequest rpRegistrationRequest) {
        Assert.notNull((Object)rpRegistrationRequest, (String)"rpRegistrationRequest cannot be null");
        Bytes credentialId = rpRegistrationRequest.getPublicKey().getCredential().getRawId();
        CredentialRecord existingCredential = this.userCredentials.findByCredentialId(credentialId);
        if (existingCredential != null) {
            throw new IllegalArgumentException("Credential with id " + String.valueOf(credentialId) + " already exists");
        }
        PublicKeyCredentialCreationOptions creationOptions = rpRegistrationRequest.getCreationOptions();
        String rpId = creationOptions.getRp().getId();
        RelyingPartyPublicKey publicKey = rpRegistrationRequest.getPublicKey();
        PublicKeyCredential<AuthenticatorAttestationResponse> credential = publicKey.getCredential();
        AuthenticatorAttestationResponse response = credential.getResponse();
        Set<Origin> origins = this.toOrigins();
        byte[] base64Challenge = creationOptions.getChallenge().getBytes();
        byte[] attestationObject = response.getAttestationObject().getBytes();
        byte[] clientDataJSON = response.getClientDataJSON().getBytes();
        DefaultChallenge challenge = new DefaultChallenge(base64Challenge);
        ServerProperty serverProperty = new ServerProperty(origins, rpId, (Challenge)challenge);
        boolean userVerificationRequired = creationOptions.getAuthenticatorSelection().getUserVerification() == UserVerificationRequirement.REQUIRED;
        boolean userPresenceRequired = true;
        List<com.webauthn4j.data.PublicKeyCredentialParameters> pubKeyCredParams = this.convertCredentialParamsToWebauthn4j(creationOptions.getPubKeyCredParams());
        Set<String> transports = Webauthn4JRelyingPartyOperations.convertTransportsToString(response);
        RegistrationRequest webauthn4jRegistrationRequest = new RegistrationRequest(attestationObject, clientDataJSON, transports);
        RegistrationParameters registrationParameters = new RegistrationParameters(serverProperty, pubKeyCredParams, userVerificationRequired, userPresenceRequired);
        RegistrationData wa4jRegistrationData = this.webAuthnManager.verify(webauthn4jRegistrationRequest, registrationParameters);
        AttestationObject wa4jAttestationObject = wa4jRegistrationData.getAttestationObject();
        Assert.notNull((Object)wa4jAttestationObject, (String)"attestationObject cannot be null");
        AuthenticatorData wa4jAuthData = wa4jAttestationObject.getAuthenticatorData();
        CborConverter cborConverter = this.objectConverter.getCborConverter();
        AttestedCredentialData wa4jCredData = wa4jAuthData.getAttestedCredentialData();
        Assert.notNull((Object)wa4jCredData, (String)"attestedCredentialData cannot be null");
        COSEKey coseKey = wa4jCredData.getCOSEKey();
        byte[] rawCoseKey = cborConverter.writeValueAsBytes((Object)coseKey);
        ImmutableCredentialRecord userCredential = ImmutableCredentialRecord.builder().userEntityUserId(creationOptions.getUser().getId()).credentialType(credential.getType()).credentialId(credential.getRawId()).publicKey(new ImmutablePublicKeyCose(rawCoseKey)).signatureCount(wa4jAuthData.getSignCount()).uvInitialized(wa4jAuthData.isFlagUV()).transports(Webauthn4JRelyingPartyOperations.convertTransports(wa4jRegistrationData.getTransports())).backupEligible(wa4jAuthData.isFlagBE()).backupState(wa4jAuthData.isFlagBS()).label(publicKey.getLabel()).attestationClientDataJSON(credential.getResponse().getClientDataJSON()).attestationObject(credential.getResponse().getAttestationObject()).build();
        this.userCredentials.save(userCredential);
        return userCredential;
    }

    private static @Nullable Set<String> convertTransportsToString(AuthenticatorAttestationResponse response) {
        if (response.getTransports() == null) {
            return null;
        }
        HashSet<String> transports = new HashSet<String>(response.getTransports().size());
        for (AuthenticatorTransport transport : response.getTransports()) {
            transports.add(transport.getValue());
        }
        return transports;
    }

    private List<com.webauthn4j.data.PublicKeyCredentialParameters> convertCredentialParamsToWebauthn4j(List<PublicKeyCredentialParameters> parameters) {
        return parameters.stream().map(this::convertParamToWebauthn4j).toList();
    }

    private com.webauthn4j.data.PublicKeyCredentialParameters convertParamToWebauthn4j(PublicKeyCredentialParameters parameter) {
        if (parameter.getType() != PublicKeyCredentialType.PUBLIC_KEY) {
            throw new IllegalArgumentException("Cannot convert unknown credential type " + String.valueOf(parameter.getType()) + " to webauthn4j");
        }
        long algValue = parameter.getAlg().getValue();
        COSEAlgorithmIdentifier alg = COSEAlgorithmIdentifier.create((long)algValue);
        return new com.webauthn4j.data.PublicKeyCredentialParameters(com.webauthn4j.data.PublicKeyCredentialType.PUBLIC_KEY, alg);
    }

    private Set<Origin> toOrigins() {
        return this.allowedOrigins.stream().map(Origin::new).collect(Collectors.toSet());
    }

    private static Set<AuthenticatorTransport> convertTransports(@Nullable Set<com.webauthn4j.data.AuthenticatorTransport> transports) {
        if (transports == null) {
            return Collections.emptySet();
        }
        return transports.stream().map(t -> AuthenticatorTransport.valueOf(t.getValue())).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public PublicKeyCredentialRequestOptions createCredentialRequestOptions(PublicKeyCredentialRequestOptionsRequest request) {
        Authentication authentication = request.getAuthentication();
        List<CredentialRecord> credentialRecords = this.findCredentialRecords(authentication);
        return PublicKeyCredentialRequestOptions.builder().allowCredentials(Webauthn4JRelyingPartyOperations.credentialDescriptors(credentialRecords)).challenge(Bytes.random()).rpId(this.rp.getId()).timeout(Duration.ofMinutes(5L)).userVerification(UserVerificationRequirement.PREFERRED).customize(this.customizeRequestOptions).build();
    }

    @NullUnmarked
    private List<CredentialRecord> findCredentialRecords(@Nullable Authentication authentication) {
        if (!this.trustResolver.isAuthenticated(authentication)) {
            return Collections.emptyList();
        }
        PublicKeyCredentialUserEntity userEntity = this.userEntities.findByUsername(authentication.getName());
        if (userEntity == null) {
            return Collections.emptyList();
        }
        return this.userCredentials.findByUserId(userEntity.getId());
    }

    @Override
    public PublicKeyCredentialUserEntity authenticate(RelyingPartyAuthenticationRequest request) {
        PublicKeyCredentialRequestOptions requestOptions = request.getRequestOptions();
        AuthenticatorAssertionResponse assertionResponse = request.getPublicKey().getResponse();
        Bytes keyId = request.getPublicKey().getRawId();
        CredentialRecord credentialRecord = this.userCredentials.findByCredentialId(keyId);
        if (credentialRecord == null) {
            throw new IllegalArgumentException("Unable to find CredentialRecord with id " + String.valueOf(keyId));
        }
        CborConverter cborConverter = this.objectConverter.getCborConverter();
        Bytes attestationObject = credentialRecord.getAttestationObject();
        Assert.notNull((Object)attestationObject, (String)"attestationObject cannot be null");
        AttestationObject wa4jAttestationObject = (AttestationObject)cborConverter.readValue(attestationObject.getBytes(), AttestationObject.class);
        Assert.notNull((Object)wa4jAttestationObject, (String)"attestationObject cannot be null");
        AuthenticatorData wa4jAuthData = wa4jAttestationObject.getAuthenticatorData();
        AttestedCredentialData wa4jCredData = wa4jAuthData.getAttestedCredentialData();
        Assert.notNull((Object)wa4jCredData, (String)"attestedCredentialData cannot be null");
        Set<Origin> origins = this.toOrigins();
        DefaultChallenge challenge = new DefaultChallenge(requestOptions.getChallenge().getBytes());
        String rpId = requestOptions.getRpId();
        Assert.notNull((Object)rpId, (String)"rpId cannot be null");
        ServerProperty serverProperty = new ServerProperty(origins, rpId, (Challenge)challenge);
        boolean userVerificationRequired = request.getRequestOptions().getUserVerification() == UserVerificationRequirement.REQUIRED;
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(request.getPublicKey().getId().getBytes(), assertionResponse.getAuthenticatorData().getBytes(), assertionResponse.getClientDataJSON().getBytes(), assertionResponse.getSignature().getBytes());
        CredentialRecordImpl wa4jCredentialRecord = new CredentialRecordImpl(wa4jAttestationObject, null, null, Webauthn4JRelyingPartyOperations.convertTransportsToWebauthn4j(credentialRecord.getTransports()));
        List<byte[]> allowCredentials = Webauthn4JRelyingPartyOperations.convertAllowedCredentialsToWebauthn4j(request.getRequestOptions().getAllowCredentials());
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (com.webauthn4j.credential.CredentialRecord)wa4jCredentialRecord, allowCredentials.isEmpty() ? null : allowCredentials, userVerificationRequired);
        AuthenticationData wa4jAuthenticationData = this.webAuthnManager.verify(authenticationRequest, authenticationParameters);
        AuthenticatorData wa4jValidatedAuthData = wa4jAuthenticationData.getAuthenticatorData();
        Assert.notNull((Object)wa4jValidatedAuthData, (String)"authenticatorData cannot be null");
        long updatedSignCount = wa4jValidatedAuthData.getSignCount();
        ImmutableCredentialRecord updatedRecord = ImmutableCredentialRecord.fromCredentialRecord(credentialRecord).lastUsed(Instant.now()).signatureCount(updatedSignCount).build();
        this.userCredentials.save(updatedRecord);
        PublicKeyCredentialUserEntity userEntity = this.userEntities.findById(credentialRecord.getUserEntityUserId());
        if (userEntity == null) {
            throw new IllegalArgumentException("Unable to find UserEntity with id " + String.valueOf(credentialRecord.getUserEntityUserId()) + " for " + String.valueOf(request));
        }
        return userEntity;
    }

    private static Set<com.webauthn4j.data.AuthenticatorTransport> convertTransportsToWebauthn4j(Set<AuthenticatorTransport> transports) {
        return transports.stream().map(AuthenticatorTransport::getValue).map(com.webauthn4j.data.AuthenticatorTransport::create).collect(Collectors.toSet());
    }

    private static List<byte[]> convertAllowedCredentialsToWebauthn4j(List<PublicKeyCredentialDescriptor> allowedCredentials) {
        return allowedCredentials.stream().map(PublicKeyCredentialDescriptor::getId).filter(Objects::nonNull).map(Bytes::getBytes).collect(Collectors.toList());
    }
}

