/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import org.springframework.security.web.webauthn.api.CredProtectAuthenticationExtensionsClientInput;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

class CredProtectAuthenticationExtensionsClientInputSerializer
extends StdSerializer<CredProtectAuthenticationExtensionsClientInput> {
    protected CredProtectAuthenticationExtensionsClientInputSerializer() {
        super(CredProtectAuthenticationExtensionsClientInput.class);
    }

    public void serialize(CredProtectAuthenticationExtensionsClientInput input, JsonGenerator jgen, SerializationContext ctxt) throws JacksonException {
        CredProtectAuthenticationExtensionsClientInput.CredProtect credProtect = input.getInput();
        String policy = CredProtectAuthenticationExtensionsClientInputSerializer.toString(credProtect.getCredProtectionPolicy());
        jgen.writePOJOProperty("credentialProtectionPolicy", (Object)policy);
        jgen.writePOJOProperty("enforceCredentialProtectionPolicy", (Object)credProtect.isEnforceCredentialProtectionPolicy());
    }

    private static String toString(CredProtectAuthenticationExtensionsClientInput.CredProtect.ProtectionPolicy policy) {
        switch (policy) {
            case USER_VERIFICATION_OPTIONAL: {
                return "userVerificationOptional";
            }
            case USER_VERIFICATION_OPTIONAL_WITH_CREDENTIAL_ID_LIST: {
                return "userVerificationOptionalWithCredentialIdList";
            }
            case USER_VERIFICATION_REQUIRED: {
                return "userVerificationRequired";
            }
        }
        throw new IllegalArgumentException("Unsupported ProtectionPolicy " + String.valueOf((Object)policy));
    }
}

