/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorResponse;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.util.Assert;

public final class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    private static final long serialVersionUID = 324976481675434298L;
    private final Bytes authenticatorData;
    private final Bytes signature;
    private final @Nullable Bytes userHandle;
    private final @Nullable Bytes attestationObject;

    private AuthenticatorAssertionResponse(Bytes clientDataJSON, Bytes authenticatorData, Bytes signature, @Nullable Bytes userHandle, @Nullable Bytes attestationObject) {
        super(clientDataJSON);
        this.authenticatorData = authenticatorData;
        this.signature = signature;
        this.userHandle = userHandle;
        this.attestationObject = attestationObject;
    }

    public Bytes getAuthenticatorData() {
        return this.authenticatorData;
    }

    public Bytes getSignature() {
        return this.signature;
    }

    public @Nullable Bytes getUserHandle() {
        return this.userHandle;
    }

    public @Nullable Bytes getAttestationObject() {
        return this.attestationObject;
    }

    public static AuthenticatorAssertionResponseBuilder builder() {
        return new AuthenticatorAssertionResponseBuilder();
    }

    public static final class AuthenticatorAssertionResponseBuilder {
        private @Nullable Bytes authenticatorData;
        private @Nullable Bytes signature;
        private @Nullable Bytes userHandle;
        private @Nullable Bytes attestationObject;
        private @Nullable Bytes clientDataJSON;

        private AuthenticatorAssertionResponseBuilder() {
        }

        public AuthenticatorAssertionResponseBuilder authenticatorData(Bytes authenticatorData) {
            this.authenticatorData = authenticatorData;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder signature(Bytes signature) {
            this.signature = signature;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder userHandle(Bytes userHandle) {
            this.userHandle = userHandle;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder attestationObject(Bytes attestationObject) {
            this.attestationObject = attestationObject;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder clientDataJSON(Bytes clientDataJSON) {
            this.clientDataJSON = clientDataJSON;
            return this;
        }

        public AuthenticatorAssertionResponse build() {
            Assert.notNull((Object)this.clientDataJSON, (String)"clientDataJSON cannot be null");
            Assert.notNull((Object)this.authenticatorData, (String)"authenticatorData cannot be null");
            Assert.notNull((Object)this.signature, (String)"signature cannot be null");
            return new AuthenticatorAssertionResponse(this.clientDataJSON, this.authenticatorData, this.signature, this.userHandle, this.attestationObject);
        }
    }
}

