/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

class AuthenticatorTransportDeserializer
extends StdDeserializer<AuthenticatorTransport> {
    AuthenticatorTransportDeserializer() {
        super(AuthenticatorTransport.class);
    }

    public @Nullable AuthenticatorTransport deserialize(JsonParser parser, DeserializationContext ctxt) throws JacksonException {
        String transportValue = (String)parser.readValueAs(String.class);
        for (AuthenticatorTransport transport : AuthenticatorTransport.values()) {
            if (!transport.getValue().equals(transportValue)) continue;
            return transport;
        }
        return null;
    }
}

