/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorAttachment;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

class AuthenticatorAttachmentDeserializer
extends StdDeserializer<AuthenticatorAttachment> {
    AuthenticatorAttachmentDeserializer() {
        super(AuthenticatorAttachment.class);
    }

    public @Nullable AuthenticatorAttachment deserialize(JsonParser parser, DeserializationContext ctxt) throws JacksonException {
        String type = (String)parser.readValueAs(String.class);
        for (AuthenticatorAttachment publicKeyCredentialType : AuthenticatorAttachment.values()) {
            if (!publicKeyCredentialType.getValue().equals(type)) continue;
            return publicKeyCredentialType;
        }
        return null;
    }
}

