/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.util.Assert;

public class WebAuthnAuthentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -4879907158750659197L;
    private final PublicKeyCredentialUserEntity principal;

    public WebAuthnAuthentication(PublicKeyCredentialUserEntity principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        super.setAuthenticated(true);
    }

    private WebAuthnAuthentication(Builder<?> builder) {
        super(builder);
        this.principal = builder.principal;
    }

    public void setAuthenticated(boolean authenticated) {
        Assert.isTrue((!authenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted");
        super.setAuthenticated(authenticated);
    }

    public @Nullable Object getCredentials() {
        return null;
    }

    public PublicKeyCredentialUserEntity getPrincipal() {
        return this.principal;
    }

    public String getName() {
        return this.principal.getName();
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static final class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private PublicKeyCredentialUserEntity principal;

        private Builder(WebAuthnAuthentication token) {
            super((AbstractAuthenticationToken)token);
            this.principal = token.principal;
        }

        public B principal(@Nullable Object principal) {
            Assert.isInstanceOf(PublicKeyCredentialUserEntity.class, (Object)principal, (String)"principal must be of type PublicKeyCredentialUserEntity");
            this.principal = (PublicKeyCredentialUserEntity)principal;
            return (B)((Object)this);
        }

        public WebAuthnAuthentication build() {
            return new WebAuthnAuthentication(this);
        }
    }
}

