/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.registration;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.CredentialRecord;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialCreationOptions;
import org.springframework.security.web.webauthn.jackson.WebauthnJackson2Module;
import org.springframework.security.web.webauthn.management.ImmutableRelyingPartyRegistrationRequest;
import org.springframework.security.web.webauthn.management.RelyingPartyPublicKey;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.security.web.webauthn.registration.HttpSessionPublicKeyCredentialCreationOptionsRepository;
import org.springframework.security.web.webauthn.registration.PublicKeyCredentialCreationOptionsRepository;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebAuthnRegistrationFilter
extends OncePerRequestFilter {
    static final String DEFAULT_REGISTER_CREDENTIAL_URL = "/webauthn/register";
    private static final Log logger = LogFactory.getLog(WebAuthnRegistrationFilter.class);
    private final WebAuthnRelyingPartyOperations rpOptions;
    private final UserCredentialRepository userCredentials;
    private HttpMessageConverter<Object> converter = new MappingJackson2HttpMessageConverter(((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new WebauthnJackson2Module())).build());
    private PublicKeyCredentialCreationOptionsRepository creationOptionsRepository = new HttpSessionPublicKeyCredentialCreationOptionsRepository();
    private RequestMatcher registerCredentialMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, "/webauthn/register");
    private RequestMatcher removeCredentialMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.DELETE, "/webauthn/register/{id}");

    public WebAuthnRegistrationFilter(UserCredentialRepository userCredentials, WebAuthnRelyingPartyOperations rpOptions) {
        Assert.notNull((Object)userCredentials, (String)"userCredentials must not be null");
        Assert.notNull((Object)rpOptions, (String)"rpOptions must not be null");
        this.userCredentials = userCredentials;
        this.rpOptions = rpOptions;
    }

    public void setRegisterCredentialMatcher(RequestMatcher registerCredentialMatcher) {
        Assert.notNull((Object)registerCredentialMatcher, (String)"registerCredentialMatcher cannot be null");
        this.registerCredentialMatcher = registerCredentialMatcher;
    }

    public void setRemoveCredentialMatcher(RequestMatcher removeCredentialMatcher) {
        Assert.notNull((Object)removeCredentialMatcher, (String)"removeCredentialMatcher cannot be null");
        this.removeCredentialMatcher = removeCredentialMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.registerCredentialMatcher.matches(request)) {
            this.registerCredential(request, response);
            return;
        }
        RequestMatcher.MatchResult removeMatchResult = this.removeCredentialMatcher.matcher(request);
        if (removeMatchResult.isMatch()) {
            String id = (String)removeMatchResult.getVariables().get("id");
            this.removeCredential(request, response, id);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setConverter(HttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = converter;
    }

    public void setCreationOptionsRepository(PublicKeyCredentialCreationOptionsRepository creationOptionsRepository) {
        Assert.notNull((Object)creationOptionsRepository, (String)"creationOptionsRepository cannot be null");
        this.creationOptionsRepository = creationOptionsRepository;
    }

    private void registerCredential(HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebAuthnRegistrationRequest registrationRequest = this.readRegistrationRequest(request);
        if (registrationRequest == null) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        PublicKeyCredentialCreationOptions options = this.creationOptionsRepository.load(request);
        if (options == null) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        this.creationOptionsRepository.save(request, response, null);
        CredentialRecord credentialRecord = this.rpOptions.registerCredential(new ImmutableRelyingPartyRegistrationRequest(options, registrationRequest.getPublicKey()));
        SuccessfulUserRegistrationResponse registrationResponse = new SuccessfulUserRegistrationResponse(credentialRecord);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        this.converter.write((Object)registrationResponse, MediaType.APPLICATION_JSON, (HttpOutputMessage)outputMessage);
    }

    private WebAuthnRegistrationRequest readRegistrationRequest(HttpServletRequest request) {
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request);
        try {
            return (WebAuthnRegistrationRequest)this.converter.read(WebAuthnRegistrationRequest.class, (HttpInputMessage)inputMessage);
        }
        catch (Exception ex) {
            logger.debug((Object)"Unable to parse WebAuthnRegistrationRequest", (Throwable)ex);
            return null;
        }
    }

    private void removeCredential(HttpServletRequest request, HttpServletResponse response, String id) throws IOException {
        this.userCredentials.delete(Bytes.fromBase64(id));
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    static class WebAuthnRegistrationRequest {
        private RelyingPartyPublicKey publicKey;

        WebAuthnRegistrationRequest() {
        }

        RelyingPartyPublicKey getPublicKey() {
            return this.publicKey;
        }

        void setPublicKey(RelyingPartyPublicKey publicKey) {
            this.publicKey = publicKey;
        }
    }

    public static class SuccessfulUserRegistrationResponse {
        private final CredentialRecord credentialRecord;

        SuccessfulUserRegistrationResponse(CredentialRecord credentialRecord) {
            this.credentialRecord = credentialRecord;
        }

        public boolean isSuccess() {
            return true;
        }
    }
}

