/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class AuthenticatorAttachment
implements Serializable {
    private static final long serialVersionUID = 8446133215195918090L;
    public static final AuthenticatorAttachment CROSS_PLATFORM = new AuthenticatorAttachment("cross-platform");
    public static final AuthenticatorAttachment PLATFORM = new AuthenticatorAttachment("platform");
    private final String value;

    AuthenticatorAttachment(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "AuthenticatorAttachment [" + this.value + "]";
    }

    public static AuthenticatorAttachment valueOf(String value) {
        switch (value) {
            case "cross-platform": {
                return CROSS_PLATFORM;
            }
            case "platform": {
                return PLATFORM;
            }
        }
        return new AuthenticatorAttachment(value);
    }

    public static AuthenticatorAttachment[] values() {
        return new AuthenticatorAttachment[]{CROSS_PLATFORM, PLATFORM};
    }

    private Object readResolve() throws ObjectStreamException {
        return AuthenticatorAttachment.valueOf(this.value);
    }
}

