/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.support;

import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class WebTestUtils {
    private static final SecurityContextRepository DEFAULT_CONTEXT_REPO = new HttpSessionSecurityContextRepository();
    private static final CsrfTokenRepository DEFAULT_TOKEN_REPO = new HttpSessionCsrfTokenRepository();
    private static final CsrfTokenRequestHandler DEFAULT_CSRF_HANDLER = new XorCsrfTokenRequestAttributeHandler();

    private WebTestUtils() {
    }

    @NullUnmarked
    public static SecurityContextRepository getSecurityContextRepository(HttpServletRequest request) {
        SecurityContextPersistenceFilter filter = WebTestUtils.findFilter(request, SecurityContextPersistenceFilter.class);
        if (filter != null) {
            return (SecurityContextRepository)ReflectionTestUtils.getField((Object)filter, (String)"repo");
        }
        SecurityContextHolderFilter holderFilter = WebTestUtils.findFilter(request, SecurityContextHolderFilter.class);
        if (holderFilter != null) {
            return (SecurityContextRepository)ReflectionTestUtils.getField((Object)holderFilter, (String)"securityContextRepository");
        }
        return DEFAULT_CONTEXT_REPO;
    }

    public static void setSecurityContextRepository(HttpServletRequest request, SecurityContextRepository securityContextRepository) {
        SecurityContextHolderFilter holderFilter;
        SecurityContextPersistenceFilter filter = WebTestUtils.findFilter(request, SecurityContextPersistenceFilter.class);
        if (filter != null) {
            ReflectionTestUtils.setField((Object)filter, (String)"repo", (Object)securityContextRepository);
        }
        if ((holderFilter = WebTestUtils.findFilter(request, SecurityContextHolderFilter.class)) != null) {
            ReflectionTestUtils.setField((Object)holderFilter, (String)"securityContextRepository", (Object)securityContextRepository);
        }
    }

    public static @Nullable CsrfTokenRepository getCsrfTokenRepository(HttpServletRequest request) {
        CsrfFilter filter = WebTestUtils.findFilter(request, CsrfFilter.class);
        if (filter == null) {
            return DEFAULT_TOKEN_REPO;
        }
        return (CsrfTokenRepository)ReflectionTestUtils.getField((Object)filter, (String)"tokenRepository");
    }

    public static @Nullable CsrfTokenRequestHandler getCsrfTokenRequestHandler(HttpServletRequest request) {
        CsrfFilter filter = WebTestUtils.findFilter(request, CsrfFilter.class);
        if (filter == null) {
            return DEFAULT_CSRF_HANDLER;
        }
        return (CsrfTokenRequestHandler)ReflectionTestUtils.getField((Object)filter, (String)"requestHandler");
    }

    public static void setCsrfTokenRepository(HttpServletRequest request, CsrfTokenRepository repository) {
        CsrfFilter filter = WebTestUtils.findFilter(request, CsrfFilter.class);
        if (filter != null) {
            ReflectionTestUtils.setField((Object)filter, (String)"tokenRepository", (Object)repository);
        }
    }

    static <T extends Filter> @Nullable T findFilter(HttpServletRequest request, Class<T> filterClass) {
        ServletContext servletContext = request.getServletContext();
        Filter springSecurityFilterChain = WebTestUtils.getSpringSecurityFilterChain(servletContext);
        if (springSecurityFilterChain == null) {
            return null;
        }
        List filters = (List)ReflectionTestUtils.invokeMethod((Object)springSecurityFilterChain, (String)"getFilters", (Object[])new Object[]{request});
        if (filters == null) {
            return null;
        }
        for (Filter filter : filters) {
            if (!filterClass.isAssignableFrom(filter.getClass())) continue;
            return (T)filter;
        }
        return null;
    }

    private static @Nullable Filter getSpringSecurityFilterChain(ServletContext servletContext) {
        Filter result = (Filter)servletContext.getAttribute("springSecurityFilterChain");
        if (result != null) {
            return result;
        }
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (webApplicationContext == null) {
            return null;
        }
        try {
            String beanName = "springSecurityFilterChain";
            return (Filter)webApplicationContext.getBean(beanName, Filter.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }
}

