/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.util.Collection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.security.test.context.support.WithUserDetails;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class WithUserDetailsSecurityContextFactory
implements WithSecurityContextFactory<WithUserDetails> {
    private static final boolean reactorPresent = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)WithUserDetailsSecurityContextFactory.class.getClassLoader());
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private BeanFactory beans;

    @Autowired
    WithUserDetailsSecurityContextFactory(BeanFactory beans) {
        this.beans = beans;
    }

    @Override
    public SecurityContext createSecurityContext(WithUserDetails withUser) {
        String beanName = withUser.userDetailsServiceBeanName();
        UserDetailsService userDetailsService = this.findUserDetailsService(beanName);
        String username = withUser.value();
        Assert.hasLength((String)username, (String)"value() must be non empty String");
        UserDetails principal = userDetailsService.loadUserByUsername(username);
        UsernamePasswordAuthenticationToken authentication = UsernamePasswordAuthenticationToken.authenticated((Object)principal, (Object)principal.getPassword(), (Collection)principal.getAuthorities());
        SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
        context.setAuthentication((Authentication)authentication);
        return context;
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    private UserDetailsService findUserDetailsService(String beanName) {
        UserDetailsService reactive;
        if (reactorPresent && (reactive = this.findAndAdaptReactiveUserDetailsService(beanName)) != null) {
            return reactive;
        }
        return StringUtils.hasLength((String)beanName) ? (UserDetailsService)this.beans.getBean(beanName, UserDetailsService.class) : (UserDetailsService)this.beans.getBean(UserDetailsService.class);
    }

    UserDetailsService findAndAdaptReactiveUserDetailsService(String beanName) {
        try {
            ReactiveUserDetailsService reactiveUserDetailsService = StringUtils.hasLength((String)beanName) ? (ReactiveUserDetailsService)this.beans.getBean(beanName, ReactiveUserDetailsService.class) : (ReactiveUserDetailsService)this.beans.getBean(ReactiveUserDetailsService.class);
            return new ReactiveUserDetailsServiceAdapter(reactiveUserDetailsService);
        }
        catch (BeanNotOfRequiredTypeException | NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private final class ReactiveUserDetailsServiceAdapter
    implements UserDetailsService {
        private final ReactiveUserDetailsService userDetailsService;

        private ReactiveUserDetailsServiceAdapter(ReactiveUserDetailsService userDetailsService) {
            this.userDetailsService = userDetailsService;
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            return (UserDetails)this.userDetailsService.findByUsername(username).block();
        }
    }
}

