/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.servlet.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.test.context.TestSecurityContextHolder;
import org.springframework.security.test.web.support.WebTestUtils;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

public final class SecurityMockMvcRequestPostProcessors {
    public static DigestRequestPostProcessor digest() {
        return new DigestRequestPostProcessor();
    }

    public static DigestRequestPostProcessor digest(String username) {
        return SecurityMockMvcRequestPostProcessors.digest().username(username);
    }

    public static RequestPostProcessor x509(X509Certificate ... certificates) {
        return new X509RequestPostProcessor(certificates);
    }

    public static RequestPostProcessor x509(String resourceName) throws IOException, CertificateException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(resourceName);
        InputStream inputStream = resource.getInputStream();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(inputStream);
        return SecurityMockMvcRequestPostProcessors.x509(certificate);
    }

    public static CsrfRequestPostProcessor csrf() {
        return new CsrfRequestPostProcessor();
    }

    public static RequestPostProcessor testSecurityContext() {
        return new TestSecurityContextHolderPostProcessor();
    }

    public static UserRequestPostProcessor user(String username) {
        return new UserRequestPostProcessor(username);
    }

    public static RequestPostProcessor user(UserDetails user) {
        return new UserDetailsRequestPostProcessor(user);
    }

    public static RequestPostProcessor authentication(Authentication authentication) {
        return new AuthenticationRequestPostProcessor(authentication);
    }

    public static RequestPostProcessor anonymous() {
        return new AnonymousRequestPostProcessor();
    }

    public static RequestPostProcessor securityContext(SecurityContext securityContext) {
        return new SecurityContextRequestPostProcessor(securityContext);
    }

    public static RequestPostProcessor httpBasic(String username, String password) {
        return new HttpBasicRequestPostProcessor(username, password);
    }

    private SecurityMockMvcRequestPostProcessors() {
    }

    private static class HttpBasicRequestPostProcessor
    implements RequestPostProcessor {
        private String headerValue;

        private HttpBasicRequestPostProcessor(String username, String password) {
            byte[] toEncode;
            try {
                toEncode = (username + ":" + password).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.headerValue = "Basic " + new String(Base64.getEncoder().encode(toEncode));
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.addHeader("Authorization", (Object)this.headerValue);
            return request;
        }
    }

    private static class AnonymousRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private AuthenticationRequestPostProcessor delegate = new AuthenticationRequestPostProcessor((Authentication)new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"})));

        private AnonymousRequestPostProcessor() {
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            return this.delegate.postProcessRequest(request);
        }
    }

    public static final class UserRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private String username;
        private String password = "password";
        private static final String ROLE_PREFIX = "ROLE_";
        private Collection<? extends GrantedAuthority> authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"});
        private boolean enabled = true;
        private boolean accountNonExpired = true;
        private boolean credentialsNonExpired = true;
        private boolean accountNonLocked = true;

        private UserRequestPostProcessor(String username) {
            Assert.notNull((Object)username, (String)"username cannot be null");
            this.username = username;
        }

        public UserRequestPostProcessor roles(String ... roles) {
            ArrayList<? extends GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(roles.length);
            for (String role : roles) {
                if (role.startsWith(ROLE_PREFIX)) {
                    throw new IllegalArgumentException("Role should not start with ROLE_ since this method automatically prefixes with this value. Got " + role);
                }
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(ROLE_PREFIX + role));
            }
            this.authorities = authorities;
            return this;
        }

        public UserRequestPostProcessor authorities(GrantedAuthority ... authorities) {
            return this.authorities(Arrays.asList(authorities));
        }

        public UserRequestPostProcessor authorities(Collection<? extends GrantedAuthority> authorities) {
            this.authorities = authorities;
            return this;
        }

        public UserRequestPostProcessor password(String password) {
            this.password = password;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            UserDetailsRequestPostProcessor delegate = new UserDetailsRequestPostProcessor((UserDetails)this.createUser());
            return delegate.postProcessRequest(request);
        }

        private User createUser() {
            return new User(this.username, this.password, this.enabled, this.accountNonExpired, this.credentialsNonExpired, this.accountNonLocked, this.authorities);
        }
    }

    private static final class UserDetailsRequestPostProcessor
    implements RequestPostProcessor {
        private final RequestPostProcessor delegate;

        public UserDetailsRequestPostProcessor(UserDetails user) {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            this.delegate = new AuthenticationRequestPostProcessor((Authentication)token);
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            return this.delegate.postProcessRequest(request);
        }
    }

    private static final class AuthenticationRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private final Authentication authentication;

        private AuthenticationRequestPostProcessor(Authentication authentication) {
            this.authentication = authentication;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(this.authentication);
            this.save(this.authentication, (HttpServletRequest)request);
            return request;
        }
    }

    private static final class SecurityContextRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private final SecurityContext securityContext;

        private SecurityContextRequestPostProcessor(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            this.save(this.securityContext, (HttpServletRequest)request);
            return request;
        }
    }

    private static final class TestSecurityContextHolderPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private SecurityContext EMPTY = SecurityContextHolder.createEmptyContext();

        private TestSecurityContextHolderPostProcessor() {
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            SecurityContext existingContext = SecurityContextRequestPostProcessorSupport.TestSecurityContextRepository.getContext((HttpServletRequest)request);
            if (existingContext != null) {
                return request;
            }
            SecurityContext context = TestSecurityContextHolder.getContext();
            if (!this.EMPTY.equals(context)) {
                this.save(context, (HttpServletRequest)request);
            }
            return request;
        }
    }

    private static abstract class SecurityContextRequestPostProcessorSupport {
        private SecurityContextRequestPostProcessorSupport() {
        }

        final void save(Authentication authentication, HttpServletRequest request) {
            SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
            securityContext.setAuthentication(authentication);
            this.save(securityContext, request);
        }

        final void save(SecurityContext securityContext, HttpServletRequest request) {
            SecurityContextRepository securityContextRepository = WebTestUtils.getSecurityContextRepository(request);
            boolean isTestRepository = securityContextRepository instanceof TestSecurityContextRepository;
            if (!isTestRepository) {
                securityContextRepository = new TestSecurityContextRepository(securityContextRepository);
                WebTestUtils.setSecurityContextRepository(request, securityContextRepository);
            }
            MockHttpServletResponse response = new MockHttpServletResponse();
            HttpRequestResponseHolder requestResponseHolder = new HttpRequestResponseHolder(request, (HttpServletResponse)response);
            securityContextRepository.loadContext(requestResponseHolder);
            request = requestResponseHolder.getRequest();
            response = requestResponseHolder.getResponse();
            securityContextRepository.saveContext(securityContext, request, (HttpServletResponse)response);
        }

        static class TestSecurityContextRepository
        implements SecurityContextRepository {
            private static final String ATTR_NAME = TestSecurityContextRepository.class.getName().concat(".REPO");
            private final SecurityContextRepository delegate;

            private TestSecurityContextRepository(SecurityContextRepository delegate) {
                this.delegate = delegate;
            }

            public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
                SecurityContext result = TestSecurityContextRepository.getContext(requestResponseHolder.getRequest());
                SecurityContext delegateResult = this.delegate.loadContext(requestResponseHolder);
                return result == null ? delegateResult : result;
            }

            public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
                request.setAttribute(ATTR_NAME, (Object)context);
                this.delegate.saveContext(context, request, response);
            }

            public boolean containsContext(HttpServletRequest request) {
                return TestSecurityContextRepository.getContext(request) != null || this.delegate.containsContext(request);
            }

            private static SecurityContext getContext(HttpServletRequest request) {
                return (SecurityContext)request.getAttribute(ATTR_NAME);
            }
        }
    }

    public static class DigestRequestPostProcessor
    implements RequestPostProcessor {
        private String username = "user";
        private String password = "password";
        private String realm = "Spring Security";
        private String nonce = DigestRequestPostProcessor.generateNonce(60);
        private String qop = "auth";
        private String nc = "00000001";
        private String cnonce = "c822c727a648aba7";

        private DigestRequestPostProcessor username(String username) {
            Assert.notNull((Object)username, (String)"username cannot be null");
            this.username = username;
            return this;
        }

        public DigestRequestPostProcessor password(String password) {
            Assert.notNull((Object)password, (String)"password cannot be null");
            this.password = password;
            return this;
        }

        public DigestRequestPostProcessor realm(String realm) {
            Assert.notNull((Object)realm, (String)"realm cannot be null");
            this.realm = realm;
            return this;
        }

        private static String generateNonce(int validitySeconds) {
            long expiryTime = System.currentTimeMillis() + (long)(validitySeconds * 1000);
            String toDigest = expiryTime + ":key";
            String signatureValue = DigestRequestPostProcessor.md5Hex(toDigest);
            String nonceValue = expiryTime + ":" + signatureValue;
            return new String(Base64.getEncoder().encode(nonceValue.getBytes()));
        }

        private String createAuthorizationHeader(MockHttpServletRequest request) {
            String uri = request.getRequestURI();
            String responseDigest = DigestRequestPostProcessor.generateDigest(this.username, this.realm, this.password, request.getMethod(), uri, this.qop, this.nonce, this.nc, this.cnonce);
            return "Digest username=\"" + this.username + "\", realm=\"" + this.realm + "\", nonce=\"" + this.nonce + "\", uri=\"" + uri + "\", response=\"" + responseDigest + "\", qop=" + this.qop + ", nc=" + this.nc + ", cnonce=\"" + this.cnonce + "\"";
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.addHeader("Authorization", (Object)this.createAuthorizationHeader(request));
            return request;
        }

        private static String generateDigest(String username, String realm, String password, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) throws IllegalArgumentException {
            String digest;
            String a1Md5 = DigestRequestPostProcessor.encodePasswordInA1Format(username, realm, password);
            String a2 = httpMethod + ":" + uri;
            String a2Md5 = DigestRequestPostProcessor.md5Hex(a2);
            if (qop == null) {
                digest = a1Md5 + ":" + nonce + ":" + a2Md5;
            } else if ("auth".equals(qop)) {
                digest = a1Md5 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2Md5;
            } else {
                throw new IllegalArgumentException("This method does not support a qop: '" + qop + "'");
            }
            return DigestRequestPostProcessor.md5Hex(digest);
        }

        static String encodePasswordInA1Format(String username, String realm, String password) {
            String a1 = username + ":" + realm + ":" + password;
            return DigestRequestPostProcessor.md5Hex(a1);
        }

        private static String md5Hex(String a2) {
            try {
                return DigestUtils.md5DigestAsHex((byte[])a2.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CsrfRequestPostProcessor
    implements RequestPostProcessor {
        private boolean asHeader;
        private boolean useInvalidToken;

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            String tokenValue;
            CsrfTokenRepository repository = WebTestUtils.getCsrfTokenRepository((HttpServletRequest)request);
            if (!(repository instanceof TestCsrfTokenRepository)) {
                repository = new TestCsrfTokenRepository((CsrfTokenRepository)new HttpSessionCsrfTokenRepository());
                WebTestUtils.setCsrfTokenRepository((HttpServletRequest)request, repository);
            }
            TestCsrfTokenRepository.enable((HttpServletRequest)request);
            CsrfToken token = repository.generateToken((HttpServletRequest)request);
            repository.saveToken(token, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            String string = tokenValue = this.useInvalidToken ? "invalid" + token.getToken() : token.getToken();
            if (this.asHeader) {
                request.addHeader(token.getHeaderName(), (Object)tokenValue);
            } else {
                request.setParameter(token.getParameterName(), tokenValue);
            }
            return request;
        }

        public CsrfRequestPostProcessor asHeader() {
            this.asHeader = true;
            return this;
        }

        public CsrfRequestPostProcessor useInvalidToken() {
            this.useInvalidToken = true;
            return this;
        }

        private CsrfRequestPostProcessor() {
        }

        static class TestCsrfTokenRepository
        implements CsrfTokenRepository {
            static final String TOKEN_ATTR_NAME = TestCsrfTokenRepository.class.getName().concat(".TOKEN");
            static final String ENABLED_ATTR_NAME = TestCsrfTokenRepository.class.getName().concat(".ENABLED");
            private final CsrfTokenRepository delegate;

            private TestCsrfTokenRepository(CsrfTokenRepository delegate) {
                this.delegate = delegate;
            }

            public CsrfToken generateToken(HttpServletRequest request) {
                return this.delegate.generateToken(request);
            }

            public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
                if (this.isEnabled(request)) {
                    request.setAttribute(TOKEN_ATTR_NAME, (Object)token);
                } else {
                    this.delegate.saveToken(token, request, response);
                }
            }

            public CsrfToken loadToken(HttpServletRequest request) {
                if (this.isEnabled(request)) {
                    return (CsrfToken)request.getAttribute(TOKEN_ATTR_NAME);
                }
                return this.delegate.loadToken(request);
            }

            public static void enable(HttpServletRequest request) {
                request.setAttribute(ENABLED_ATTR_NAME, (Object)Boolean.TRUE);
            }

            public boolean isEnabled(HttpServletRequest request) {
                return Boolean.TRUE.equals(request.getAttribute(ENABLED_ATTR_NAME));
            }
        }
    }

    private static class X509RequestPostProcessor
    implements RequestPostProcessor {
        private final X509Certificate[] certificates;

        private X509RequestPostProcessor(X509Certificate ... certificates) {
            Assert.notNull((Object)certificates, (String)"X509Certificate cannot be null");
            this.certificates = certificates;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.setAttribute("javax.servlet.request.X509Certificate", (Object)this.certificates);
            return request;
        }
    }
}

