/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.util.ArrayList;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WithMockUserSecurityContextFactory
implements WithSecurityContextFactory<WithMockUser> {
    WithMockUserSecurityContextFactory() {
    }

    @Override
    public SecurityContext createSecurityContext(WithMockUser withUser) {
        String username;
        String string = username = StringUtils.hasLength((String)withUser.username()) ? withUser.username() : withUser.value();
        if (username == null) {
            throw new IllegalArgumentException(withUser + " cannot have null username on both username and value properites");
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String role : withUser.roles()) {
            if (role.startsWith("ROLE_")) {
                throw new IllegalArgumentException("roles cannot start with ROLE_ Got " + role);
            }
            authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
        }
        User principal = new User(username, withUser.password(), true, true, true, true, authorities);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), principal.getAuthorities());
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication((Authentication)authentication);
        return context;
    }
}

