/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class Saml2WebSsoAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_FILTER_PROCESSES_URI = "/login/saml2/sso/{registrationId}";
    private static final RequestMatcher DEFAULT_REQUEST_MATCHER = new OrRequestMatcher(new RequestMatcher[]{PathPatternRequestMatcher.pathPattern((String)"/login/saml2/sso/{registrationId}"), PathPatternRequestMatcher.pathPattern((String)"/login/saml2/sso")});
    private final AuthenticationConverter authenticationConverter;
    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository = new HttpSessionSaml2AuthenticationRequestRepository();
    private boolean continueChainWhenNoRelyingPartyRegistrationFound = false;

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        this(relyingPartyRegistrationRepository, DEFAULT_FILTER_PROCESSES_URI);
        PathPatternRequestMatcher processUri = PathPatternRequestMatcher.pathPattern((String)DEFAULT_FILTER_PROCESSES_URI);
        this.setRequiresAuthenticationRequestMatcher((RequestMatcher)processUri);
    }

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository, String filterProcessesUrl) {
        this(new Saml2AuthenticationTokenConverter(new DefaultRelyingPartyRegistrationResolver(relyingPartyRegistrationRepository)), filterProcessesUrl);
        Assert.isTrue((boolean)filterProcessesUrl.contains("{registrationId}"), (String)"filterProcessesUrl must contain a {registrationId} match variable");
    }

    public Saml2WebSsoAuthenticationFilter(AuthenticationConverter authenticationConverter) {
        super(DEFAULT_REQUEST_MATCHER);
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        this.setAllowSessionCreation(true);
        this.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
        this.setAuthenticationConverter(authenticationConverter);
    }

    public Saml2WebSsoAuthenticationFilter(AuthenticationConverter authenticationConverter, String filterProcessesUrl) {
        super(filterProcessesUrl);
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        Assert.hasText((String)filterProcessesUrl, (String)"filterProcessesUrl must contain a URL pattern");
        this.authenticationConverter = authenticationConverter;
        this.setAllowSessionCreation(true);
        this.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
        this.setAuthenticationConverter(authenticationConverter);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return super.requiresAuthentication(request, response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Authentication authentication = this.authenticationConverter.convert(request);
        if (authentication == null) {
            if (this.continueChainWhenNoRelyingPartyRegistrationFound) {
                return null;
            }
            Saml2Error saml2Error = new Saml2Error("relying_party_registration_not_found", "No relying party registration found");
            throw new Saml2AuthenticationException(saml2Error);
        }
        this.setDetails(request, authentication);
        this.authenticationRequestRepository.removeAuthenticationRequest(request, response);
        return this.getAuthenticationManager().authenticate(authentication);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.setAuthenticationRequestRepositoryIntoAuthenticationConverter(authenticationRequestRepository);
    }

    private void setAuthenticationRequestRepositoryIntoAuthenticationConverter(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        AuthenticationConverter authenticationConverter = this.authenticationConverter;
        if (authenticationConverter instanceof Saml2AuthenticationTokenConverter) {
            Saml2AuthenticationTokenConverter authenticationTokenConverter = (Saml2AuthenticationTokenConverter)authenticationConverter;
            authenticationTokenConverter.setAuthenticationRequestRepository(authenticationRequestRepository);
        }
    }

    private void setDetails(HttpServletRequest request, Authentication authentication) {
        if (authentication.getDetails() != null) {
            return;
        }
        if (authentication instanceof AbstractAuthenticationToken) {
            AbstractAuthenticationToken token = (AbstractAuthenticationToken)authentication;
            Object details = this.authenticationDetailsSource.buildDetails((Object)request);
            token.setDetails(details);
        }
    }

    public void setContinueChainWhenNoRelyingPartyRegistrationFound(boolean continueChain) {
        this.continueChainWhenNoRelyingPartyRegistrationFound = continueChain;
    }
}

