/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class OpenSamlMetadataUtils {
    private static final OpenSamlDeserializer saml;

    static OpenSamlDeserializer resolveDeserializer() {
        return new OpenSaml5Deserializer();
    }

    private OpenSamlMetadataUtils() {
    }

    static Collection<EntityDescriptor> descriptors(InputStream metadata) {
        XMLObject object = saml.deserialize(metadata);
        if (object instanceof EntityDescriptor) {
            EntityDescriptor descriptor = (EntityDescriptor)object;
            return Collections.singleton(descriptor);
        }
        if (object instanceof EntitiesDescriptor) {
            EntitiesDescriptor descriptors = (EntitiesDescriptor)object;
            return descriptors.getEntityDescriptors();
        }
        throw new Saml2Exception("Unsupported element type: " + object.getClass().getName());
    }

    static {
        OpenSamlInitializationService.initialize();
        saml = OpenSamlMetadataUtils.resolveDeserializer();
    }

    private static class OpenSaml5Deserializer
    implements OpenSamlDeserializer {
        private OpenSaml5Deserializer() {
        }

        @Override
        public XMLObject deserialize(InputStream serialized) {
            try {
                Document document = XMLObjectProviderRegistrySupport.getParserPool().parse(serialized);
                Element element = document.getDocumentElement();
                UnmarshallerFactory factory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
                Unmarshaller unmarshaller = factory.getUnmarshaller(element);
                if (unmarshaller == null) {
                    throw new Saml2Exception("Unsupported element of type " + element.getTagName());
                }
                return unmarshaller.unmarshall(element);
            }
            catch (Saml2Exception ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new Saml2Exception("Failed to deserialize payload", ex);
            }
        }
    }

    private static interface OpenSamlDeserializer {
        public XMLObject deserialize(InputStream var1);
    }
}

