/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.core;

import java.io.Serializable;
import org.springframework.util.Assert;

public class Saml2Error
implements Serializable {
    private static final long serialVersionUID = 620L;
    private final String errorCode;
    private final String description;

    public Saml2Error(String errorCode, String description) {
        Assert.hasText((String)errorCode, (String)"errorCode cannot be empty");
        this.errorCode = errorCode;
        this.description = description;
    }

    public static Saml2Error invalidResponse(String description) {
        return new Saml2Error("invalid_response", description);
    }

    public static Saml2Error internalValidationError(String description) {
        return new Saml2Error("internal_validation_error", description);
    }

    public static Saml2Error malformedResponseData(String description) {
        return new Saml2Error("malformed_response_data", description);
    }

    public static Saml2Error decryptionError(String description) {
        return new Saml2Error("decryption_error", description);
    }

    public static Saml2Error relyingPartyRegistrationNotFound(String description) {
        return new Saml2Error("relying_party_registration_not_found", description);
    }

    public static Saml2Error subjectNotFound(String description) {
        return new Saml2Error("subject_not_found", description);
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getDescription() {
        return this.description;
    }

    public String toString() {
        return "[" + this.getErrorCode() + "] " + (this.getDescription() != null ? this.getDescription() : "");
    }
}

