/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.util.Collection;
import java.util.function.Consumer;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.Saml2ResponseAssertionAccessor;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlOperations;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidatorParameters;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2Utils;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

class BaseOpenSamlLogoutRequestValidator
implements Saml2LogoutRequestValidator {
    private final OpenSamlOperations saml;

    BaseOpenSamlLogoutRequestValidator(OpenSamlOperations saml) {
        this.saml = saml;
    }

    @Override
    public Saml2LogoutValidatorResult validate(Saml2LogoutRequestValidatorParameters parameters) {
        Saml2LogoutRequest request = parameters.getLogoutRequest();
        RelyingPartyRegistration registration = parameters.getRelyingPartyRegistration();
        Authentication authentication = parameters.getAuthentication();
        LogoutRequest logoutRequest = (LogoutRequest)this.saml.deserialize(Saml2Utils.withEncoded(request.getSamlRequest()).inflate(request.getBinding() == Saml2MessageBinding.REDIRECT).decode());
        return Saml2LogoutValidatorResult.withErrors(new Saml2Error[0]).errors(this.verifySignature(request, logoutRequest, registration)).errors(this.validateRequest(logoutRequest, registration, authentication)).build();
    }

    private Consumer<Collection<Saml2Error>> verifySignature(Saml2LogoutRequest request, LogoutRequest logoutRequest, RelyingPartyRegistration registration) {
        AssertingPartyMetadata details = registration.getAssertingPartyMetadata();
        Collection<Saml2X509Credential> credentials = details.getVerificationX509Credentials();
        OpenSamlOperations.VerificationConfigurer verify = this.saml.withVerificationKeys(credentials).entityId(details.getEntityId());
        return errors -> {
            if (logoutRequest.isSigned()) {
                errors.addAll(verify.verify((SignableXMLObject)logoutRequest));
            } else {
                OpenSamlOperations.VerificationConfigurer.RedirectParameters params = new OpenSamlOperations.VerificationConfigurer.RedirectParameters(request.getParameters(), request.getParametersQuery(), (RequestAbstractType)logoutRequest);
                errors.addAll(verify.verify(params));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateRequest(LogoutRequest request, RelyingPartyRegistration registration, Authentication authentication) {
        return errors -> {
            this.validateIssuer(request, registration).accept((Collection<Saml2Error>)errors);
            this.validateDestination(request, registration).accept((Collection<Saml2Error>)errors);
            this.validateSubject(request, registration, authentication).accept((Collection<Saml2Error>)errors);
        };
    }

    private Consumer<Collection<Saml2Error>> validateIssuer(LogoutRequest request, RelyingPartyRegistration registration) {
        return errors -> {
            if (request.getIssuer() == null) {
                errors.add(new Saml2Error("invalid_issuer", "Failed to find issuer in LogoutRequest"));
                return;
            }
            String issuer = request.getIssuer().getValue();
            if (!issuer.equals(registration.getAssertingPartyMetadata().getEntityId())) {
                errors.add(new Saml2Error("invalid_issuer", "Failed to match issuer to configured issuer"));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateDestination(LogoutRequest request, RelyingPartyRegistration registration) {
        return errors -> {
            if (request.getDestination() == null) {
                errors.add(new Saml2Error("invalid_destination", "Failed to find destination in LogoutRequest"));
                return;
            }
            String destination = request.getDestination();
            if (!destination.equals(registration.getSingleLogoutServiceLocation())) {
                errors.add(new Saml2Error("invalid_destination", "Failed to match destination to configured destination"));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateSubject(LogoutRequest request, RelyingPartyRegistration registration, Authentication authentication) {
        return errors -> {
            if (authentication == null) {
                return;
            }
            NameID nameId = this.getNameId(request, registration);
            if (nameId == null) {
                errors.add(new Saml2Error("subject_not_found", "Failed to find subject in LogoutRequest"));
                return;
            }
            this.validateNameId(nameId, authentication, (Collection<Saml2Error>)errors);
        };
    }

    private NameID getNameId(LogoutRequest request, RelyingPartyRegistration registration) {
        this.saml.withDecryptionKeys(registration.getDecryptionX509Credentials()).decrypt((XMLObject)request);
        return request.getNameID();
    }

    private void validateNameId(NameID nameId, Authentication authentication, Collection<Saml2Error> errors) {
        String name;
        Object object = authentication.getCredentials();
        if (object instanceof Saml2ResponseAssertionAccessor) {
            Saml2ResponseAssertionAccessor assertion = (Saml2ResponseAssertionAccessor)object;
            v0 = assertion.getNameId();
        } else {
            v0 = name = authentication.getName();
        }
        if (!nameId.getValue().equals(name)) {
            errors.add(new Saml2Error("invalid_request", "Failed to match subject in LogoutRequest with currently logged in user"));
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

