/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.util.function.Consumer;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.BaseOpenSamlAuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml5Template;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OpenSaml5AuthenticationRequestResolver
implements Saml2AuthenticationRequestResolver {
    private final BaseOpenSamlAuthenticationRequestResolver delegate;

    public OpenSaml5AuthenticationRequestResolver(RelyingPartyRegistrationRepository registrations) {
        this.delegate = new BaseOpenSamlAuthenticationRequestResolver((request, id) -> {
            if (id == null) {
                return null;
            }
            return registrations.findByRegistrationId(id);
        }, new OpenSaml5Template());
    }

    public OpenSaml5AuthenticationRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.delegate = new BaseOpenSamlAuthenticationRequestResolver(relyingPartyRegistrationResolver, new OpenSaml5Template());
    }

    @Override
    public <T extends AbstractSaml2AuthenticationRequest> T resolve(HttpServletRequest request) {
        return this.delegate.resolve(request);
    }

    public void setAuthnRequestCustomizer(Consumer<AuthnRequestContext> contextConsumer) {
        Assert.notNull(contextConsumer, (String)"contextConsumer cannot be null");
        this.delegate.setParametersConsumer(parameters -> contextConsumer.accept(new AuthnRequestContext(parameters.getRequest(), parameters.getRelyingPartyRegistration(), parameters.getAuthnRequest())));
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.delegate.setRequestMatcher(requestMatcher);
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock must not be null");
        this.delegate.setClock(clock);
    }

    public void setRelayStateResolver(Converter<HttpServletRequest, String> relayStateResolver) {
        Assert.notNull(relayStateResolver, (String)"relayStateResolver cannot be null");
        this.delegate.setRelayStateResolver(relayStateResolver);
    }

    public static final class AuthnRequestContext {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final AuthnRequest authnRequest;

        public AuthnRequestContext(HttpServletRequest request, RelyingPartyRegistration registration, AuthnRequest authnRequest) {
            this.request = request;
            this.registration = registration;
            this.authnRequest = authnRequest;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        public AuthnRequest getAuthnRequest() {
            return this.authnRequest;
        }
    }
}

