/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2ResponseAssertionAccessor;

public class Saml2AssertionAuthentication
extends Saml2Authentication {
    private static final long serialVersionUID = -4194323643788693205L;
    private final Saml2ResponseAssertionAccessor assertion;
    private final String relyingPartyRegistrationId;

    public Saml2AssertionAuthentication(Saml2ResponseAssertionAccessor assertion, Collection<? extends GrantedAuthority> authorities, String relyingPartyRegistrationId) {
        super(assertion, assertion.getResponseValue(), authorities);
        this.assertion = assertion;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
    }

    public Saml2AssertionAuthentication(Object principal, Saml2ResponseAssertionAccessor assertion, Collection<? extends GrantedAuthority> authorities, String relyingPartyRegistrationId) {
        super(principal, assertion.getResponseValue(), authorities);
        this.assertion = assertion;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
        this.setAuthenticated(true);
    }

    @Override
    public Saml2ResponseAssertionAccessor getCredentials() {
        return this.assertion;
    }

    public String getRelyingPartyRegistrationId() {
        return this.relyingPartyRegistrationId;
    }
}

