/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.metadata;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResponse;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResponseResolver;
import org.springframework.security.saml2.provider.service.registration.IterableRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class RequestMatcherMetadataResponseResolver
implements Saml2MetadataResponseResolver {
    private static final String DEFAULT_METADATA_FILENAME = "saml-{registrationId}-metadata.xml";
    private RequestMatcher matcher = new OrRequestMatcher(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/saml2/service-provider-metadata/{registrationId}"), PathPatternRequestMatcher.withDefaults().matcher("/saml2/metadata/{registrationId}"), PathPatternRequestMatcher.withDefaults().matcher("/saml2/metadata")});
    private String filename = "saml-{registrationId}-metadata.xml";
    private final RelyingPartyRegistrationRepository registrations;
    private final Saml2MetadataResolver metadata;

    public RequestMatcherMetadataResponseResolver(RelyingPartyRegistrationRepository registrations, Saml2MetadataResolver metadata) {
        Assert.notNull((Object)registrations, (String)"relyingPartyRegistrationRepository cannot be null");
        Assert.notNull((Object)metadata, (String)"saml2MetadataResolver cannot be null");
        this.registrations = registrations;
        this.metadata = metadata;
    }

    @Override
    public Saml2MetadataResponse resolve(HttpServletRequest request) {
        RequestMatcher.MatchResult result = this.matcher.matcher(request);
        if (!result.isMatch()) {
            return null;
        }
        String registrationId = (String)result.getVariables().get("registrationId");
        Saml2MetadataResponse response = this.responseByRegistrationId(request, registrationId);
        if (response != null) {
            return response;
        }
        RelyingPartyRegistrationRepository relyingPartyRegistrationRepository = this.registrations;
        if (relyingPartyRegistrationRepository instanceof IterableRelyingPartyRegistrationRepository) {
            IterableRelyingPartyRegistrationRepository iterable = (IterableRelyingPartyRegistrationRepository)relyingPartyRegistrationRepository;
            return this.responseByIterable(request, iterable);
        }
        if (this.registrations instanceof Iterable) {
            Iterable registrations = (Iterable)((Object)this.registrations);
            return this.responseByIterable(request, registrations);
        }
        return null;
    }

    private Saml2MetadataResponse responseByRegistrationId(HttpServletRequest request, String registrationId) {
        if (registrationId == null) {
            return null;
        }
        RelyingPartyRegistration registration = this.registrations.findByRegistrationId(registrationId);
        if (registration == null) {
            throw new Saml2Exception("registration not found");
        }
        return this.responseByIterable(request, Collections.singleton(registration));
    }

    private Saml2MetadataResponse responseByIterable(HttpServletRequest request, Iterable<RelyingPartyRegistration> registrations) {
        LinkedHashMap<String, RelyingPartyRegistration> results = new LinkedHashMap<String, RelyingPartyRegistration>();
        for (RelyingPartyRegistration registration : registrations) {
            RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
            String entityId = uriResolver.resolve(registration.getEntityId());
            results.computeIfAbsent(entityId, e -> {
                String ssoLocation = uriResolver.resolve(registration.getAssertionConsumerServiceLocation());
                String sloLocation = uriResolver.resolve(registration.getSingleLogoutServiceLocation());
                String sloResponseLocation = uriResolver.resolve(registration.getSingleLogoutServiceResponseLocation());
                return registration.mutate().entityId(entityId).assertionConsumerServiceLocation(ssoLocation).singleLogoutServiceLocation(sloLocation).singleLogoutServiceResponseLocation(sloResponseLocation).build();
            });
        }
        String metadata = this.metadata.resolve(results.values());
        String value = results.size() == 1 ? ((RelyingPartyRegistration)results.values().iterator().next()).getRegistrationId() : UUID.randomUUID().toString();
        String fileName = this.filename.replace("{registrationId}", value);
        try {
            String encodedFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            return new Saml2MetadataResponse(metadata, encodedFileName);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Saml2Exception(ex);
        }
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be empty");
        this.matcher = requestMatcher;
    }

    public void setMetadataFilename(String metadataFilename) {
        Assert.hasText((String)metadataFilename, (String)"metadataFilename cannot be empty");
        this.filename = metadataFilename;
    }
}

