/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.util.Collections;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;

public class Saml2AuthenticationToken
extends AbstractAuthenticationToken {
    private final RelyingPartyRegistration relyingPartyRegistration;
    private final String saml2Response;
    private final AbstractSaml2AuthenticationRequest authenticationRequest;

    public Saml2AuthenticationToken(RelyingPartyRegistration relyingPartyRegistration, String saml2Response, AbstractSaml2AuthenticationRequest authenticationRequest) {
        super(Collections.emptyList());
        Assert.notNull((Object)relyingPartyRegistration, (String)"relyingPartyRegistration cannot be null");
        Assert.notNull((Object)saml2Response, (String)"saml2Response cannot be null");
        this.relyingPartyRegistration = relyingPartyRegistration;
        this.saml2Response = saml2Response;
        this.authenticationRequest = authenticationRequest;
    }

    public Saml2AuthenticationToken(RelyingPartyRegistration relyingPartyRegistration, String saml2Response) {
        this(relyingPartyRegistration, saml2Response, null);
    }

    public Object getCredentials() {
        return this.getSaml2Response();
    }

    public Object getPrincipal() {
        return null;
    }

    public RelyingPartyRegistration getRelyingPartyRegistration() {
        return this.relyingPartyRegistration;
    }

    public String getSaml2Response() {
        return this.saml2Response;
    }

    public boolean isAuthenticated() {
        return false;
    }

    public void setAuthenticated(boolean authenticated) {
        throw new IllegalArgumentException();
    }

    public AbstractSaml2AuthenticationRequest getAuthenticationRequest() {
        return this.authenticationRequest;
    }
}

