/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.util.Assert;

public final class Saml2ResponseValidatorResult {
    static final Saml2ResponseValidatorResult NO_ERRORS = new Saml2ResponseValidatorResult(Collections.emptyList());
    private final Collection<Saml2Error> errors;

    private Saml2ResponseValidatorResult(Collection<Saml2Error> errors) {
        Assert.notNull(errors, (String)"errors cannot be null");
        this.errors = new ArrayList<Saml2Error>(errors);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Collection<Saml2Error> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    public Saml2ResponseValidatorResult concat(Saml2Error error) {
        Assert.notNull((Object)error, (String)"error cannot be null");
        ArrayList<Saml2Error> errors = new ArrayList<Saml2Error>(this.errors);
        errors.add(error);
        return Saml2ResponseValidatorResult.failure(errors);
    }

    public Saml2ResponseValidatorResult concat(Saml2ResponseValidatorResult result) {
        Assert.notNull((Object)result, (String)"result cannot be null");
        ArrayList<Saml2Error> errors = new ArrayList<Saml2Error>(this.errors);
        errors.addAll(result.getErrors());
        return Saml2ResponseValidatorResult.failure(errors);
    }

    public static Saml2ResponseValidatorResult success() {
        return NO_ERRORS;
    }

    public static Saml2ResponseValidatorResult failure(Saml2Error ... errors) {
        return Saml2ResponseValidatorResult.failure(Arrays.asList(errors));
    }

    public static Saml2ResponseValidatorResult failure(Collection<Saml2Error> errors) {
        if (errors.isEmpty()) {
            return NO_ERRORS;
        }
        return new Saml2ResponseValidatorResult(errors);
    }
}

