/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Consumer;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.impl.LogoutRequestUnmarshaller;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.logout.LogoutRequestEncryptedIdUtils;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlVerificationUtils;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidatorParameters;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2Utils;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class OpenSamlLogoutRequestValidator
implements Saml2LogoutRequestValidator {
    private final ParserPool parserPool;
    private final LogoutRequestUnmarshaller unmarshaller;

    public OpenSamlLogoutRequestValidator() {
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.parserPool = registry.getParserPool();
        this.unmarshaller = (LogoutRequestUnmarshaller)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(LogoutRequest.DEFAULT_ELEMENT_NAME);
    }

    @Override
    public Saml2LogoutValidatorResult validate(Saml2LogoutRequestValidatorParameters parameters) {
        Saml2LogoutRequest request = parameters.getLogoutRequest();
        RelyingPartyRegistration registration = parameters.getRelyingPartyRegistration();
        Authentication authentication = parameters.getAuthentication();
        byte[] b = Saml2Utils.samlDecode(request.getSamlRequest());
        LogoutRequest logoutRequest = this.parse(this.inflateIfRequired(request, b));
        return Saml2LogoutValidatorResult.withErrors(new Saml2Error[0]).errors(this.verifySignature(request, logoutRequest, registration)).errors(this.validateRequest(logoutRequest, registration, authentication)).build();
    }

    private String inflateIfRequired(Saml2LogoutRequest request, byte[] b) {
        if (request.getBinding() == Saml2MessageBinding.REDIRECT) {
            return Saml2Utils.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    private LogoutRequest parse(String request) throws Saml2Exception {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(request.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getDocumentElement();
            return (LogoutRequest)this.unmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw new Saml2Exception("Failed to deserialize LogoutRequest", ex);
        }
    }

    private Consumer<Collection<Saml2Error>> verifySignature(Saml2LogoutRequest request, LogoutRequest logoutRequest, RelyingPartyRegistration registration) {
        return errors -> {
            OpenSamlVerificationUtils.VerifierPartial partial = OpenSamlVerificationUtils.verifySignature((RequestAbstractType)logoutRequest, registration);
            if (logoutRequest.isSigned()) {
                errors.addAll(partial.post(logoutRequest.getSignature()));
            } else {
                errors.addAll(partial.redirect(request));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateRequest(LogoutRequest request, RelyingPartyRegistration registration, Authentication authentication) {
        return errors -> {
            this.validateIssuer(request, registration).accept((Collection<Saml2Error>)errors);
            this.validateDestination(request, registration).accept((Collection<Saml2Error>)errors);
            this.validateSubject(request, registration, authentication).accept((Collection<Saml2Error>)errors);
        };
    }

    private Consumer<Collection<Saml2Error>> validateIssuer(LogoutRequest request, RelyingPartyRegistration registration) {
        return errors -> {
            if (request.getIssuer() == null) {
                errors.add(new Saml2Error("invalid_issuer", "Failed to find issuer in LogoutRequest"));
                return;
            }
            String issuer = request.getIssuer().getValue();
            if (!issuer.equals(registration.getAssertingPartyDetails().getEntityId())) {
                errors.add(new Saml2Error("invalid_issuer", "Failed to match issuer to configured issuer"));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateDestination(LogoutRequest request, RelyingPartyRegistration registration) {
        return errors -> {
            if (request.getDestination() == null) {
                errors.add(new Saml2Error("invalid_destination", "Failed to find destination in LogoutRequest"));
                return;
            }
            String destination = request.getDestination();
            if (!destination.equals(registration.getSingleLogoutServiceLocation())) {
                errors.add(new Saml2Error("invalid_destination", "Failed to match destination to configured destination"));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateSubject(LogoutRequest request, RelyingPartyRegistration registration, Authentication authentication) {
        return errors -> {
            if (authentication == null) {
                return;
            }
            NameID nameId = this.getNameId(request, registration);
            if (nameId == null) {
                errors.add(new Saml2Error("subject_not_found", "Failed to find subject in LogoutRequest"));
                return;
            }
            this.validateNameId(nameId, authentication, (Collection<Saml2Error>)errors);
        };
    }

    private NameID getNameId(LogoutRequest request, RelyingPartyRegistration registration) {
        NameID nameId = request.getNameID();
        if (nameId != null) {
            return nameId;
        }
        EncryptedID encryptedId = request.getEncryptedID();
        if (encryptedId == null) {
            return null;
        }
        return this.decryptNameId(encryptedId, registration);
    }

    private void validateNameId(NameID nameId, Authentication authentication, Collection<Saml2Error> errors) {
        String name = nameId.getValue();
        if (!name.equals(authentication.getName())) {
            errors.add(new Saml2Error("invalid_request", "Failed to match subject in LogoutRequest with currently logged in user"));
        }
    }

    private NameID decryptNameId(EncryptedID encryptedId, RelyingPartyRegistration registration) {
        SAMLObject decryptedId = LogoutRequestEncryptedIdUtils.decryptEncryptedId(encryptedId, registration);
        if (decryptedId instanceof NameID) {
            return (NameID)decryptedId;
        }
        return null;
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

