/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public final class Saml2LogoutResponse {
    private final String location;
    private final Saml2MessageBinding binding;
    private final Map<String, String> parameters;

    private Saml2LogoutResponse(String location, Saml2MessageBinding binding, Map<String, String> parameters) {
        this.location = location;
        this.binding = binding;
        this.parameters = Collections.unmodifiableMap(new HashMap<String, String>(parameters));
    }

    public String getResponseLocation() {
        return this.location;
    }

    public Saml2MessageBinding getBinding() {
        return this.binding;
    }

    public String getSamlResponse() {
        return this.parameters.get("SAMLResponse");
    }

    public String getRelayState() {
        return this.parameters.get("RelayState");
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        return new Builder(registration);
    }

    public static final class Builder {
        private String location;
        private Saml2MessageBinding binding;
        private Map<String, String> parameters = new HashMap<String, String>();

        private Builder(RelyingPartyRegistration registration) {
            this.location = registration.getAssertingPartyDetails().getSingleLogoutServiceResponseLocation();
            this.binding = registration.getAssertingPartyDetails().getSingleLogoutServiceBinding();
        }

        public Builder samlResponse(String samlResponse) {
            this.parameters.put("SAMLResponse", samlResponse);
            return this;
        }

        public Builder binding(Saml2MessageBinding binding) {
            this.binding = binding;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder relayState(String relayState) {
            this.parameters.put("RelayState", relayState);
            return this;
        }

        public Builder parameters(Consumer<Map<String, String>> parametersConsumer) {
            parametersConsumer.accept(this.parameters);
            return this;
        }

        public Saml2LogoutResponse build() {
            return new Saml2LogoutResponse(this.location, this.binding, this.parameters);
        }
    }
}

