/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

final class OpenSamlDecryptionUtils {
    private static final EncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver()));

    static void decryptResponseElements(Response response, RelyingPartyRegistration registration) {
        Decrypter decrypter = OpenSamlDecryptionUtils.decrypter(registration);
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            try {
                Assertion assertion = decrypter.decrypt(encryptedAssertion);
                response.getAssertions().add(assertion);
            }
            catch (Exception ex) {
                throw new Saml2Exception(ex);
            }
        }
    }

    static void decryptAssertionElements(Assertion assertion, RelyingPartyRegistration registration) {
        Decrypter decrypter = OpenSamlDecryptionUtils.decrypter(registration);
        for (AttributeStatement statement : assertion.getAttributeStatements()) {
            for (EncryptedAttribute encryptedAttribute : statement.getEncryptedAttributes()) {
                try {
                    Attribute attribute = decrypter.decrypt(encryptedAttribute);
                    statement.getAttributes().add(attribute);
                }
                catch (Exception ex) {
                    throw new Saml2Exception(ex);
                }
            }
        }
        if (assertion.getSubject() == null) {
            return;
        }
        if (assertion.getSubject().getEncryptedID() == null) {
            return;
        }
        try {
            assertion.getSubject().setNameID((NameID)decrypter.decrypt(assertion.getSubject().getEncryptedID()));
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private static Decrypter decrypter(RelyingPartyRegistration registration) {
        ArrayList<BasicX509Credential> credentials = new ArrayList<BasicX509Credential>();
        for (Saml2X509Credential key : registration.getDecryptionX509Credentials()) {
            BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)key.getCertificate(), (PrivateKey)key.getPrivateKey());
            credentials.add(cred);
        }
        CollectionKeyInfoCredentialResolver resolver = new CollectionKeyInfoCredentialResolver(credentials);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, encryptedKeyResolver);
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    private OpenSamlDecryptionUtils() {
    }
}

