/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.springframework.security.saml2.Saml2Exception;

public final class OpenSamlInitializationService {
    private static final Log log = LogFactory.getLog(OpenSamlInitializationService.class);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    private OpenSamlInitializationService() {
    }

    public static boolean initialize() {
        return OpenSamlInitializationService.initialize(registry -> {});
    }

    public static void requireInitialize(Consumer<XMLObjectProviderRegistry> registryConsumer) {
        if (!OpenSamlInitializationService.initialize(registryConsumer)) {
            throw new Saml2Exception("OpenSAML was already initialized previously");
        }
    }

    private static boolean initialize(Consumer<XMLObjectProviderRegistry> registryConsumer) {
        if (initialized.compareAndSet(false, true)) {
            log.trace((Object)"Initializing OpenSAML");
            try {
                InitializationService.initialize();
            }
            catch (Exception ex) {
                throw new Saml2Exception(ex);
            }
            BasicParserPool parserPool = new BasicParserPool();
            parserPool.setMaxPoolSize(50);
            parserPool.setBuilderFeatures(OpenSamlInitializationService.getParserBuilderFeatures());
            try {
                parserPool.initialize();
            }
            catch (Exception ex) {
                throw new Saml2Exception(ex);
            }
            XMLObjectProviderRegistrySupport.setParserPool((ParserPool)parserPool);
            registryConsumer.accept((XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class));
            log.debug((Object)"Initialized OpenSAML");
            return true;
        }
        log.debug((Object)"Refused to re-initialize OpenSAML");
        return false;
    }

    private static Map<String, Boolean> getParserBuilderFeatures() {
        HashMap<String, Boolean> parserBuilderFeatures = new HashMap<String, Boolean>();
        parserBuilderFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        parserBuilderFeatures.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        parserBuilderFeatures.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        parserBuilderFeatures.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        parserBuilderFeatures.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        parserBuilderFeatures.put("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        return parserBuilderFeatures;
    }
}

