/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;

abstract class AbstractSaml2AuthenticationRequest {
    private final String samlRequest;
    private final String relayState;
    private final String authenticationRequestUri;

    AbstractSaml2AuthenticationRequest(String samlRequest, String relayState, String authenticationRequestUri) {
        Assert.hasText((String)samlRequest, (String)"samlRequest cannot be null or empty");
        Assert.hasText((String)authenticationRequestUri, (String)"authenticationRequestUri cannot be null or empty");
        this.authenticationRequestUri = authenticationRequestUri;
        this.samlRequest = samlRequest;
        this.relayState = relayState;
    }

    public String getSamlRequest() {
        return this.samlRequest;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getAuthenticationRequestUri() {
        return this.authenticationRequestUri;
    }

    public abstract Saml2MessageBinding getBinding();

    static class Builder<T extends Builder<T>> {
        String authenticationRequestUri;
        String samlRequest;
        String relayState;

        protected Builder() {
        }

        protected final T _this() {
            return (T)this;
        }

        public T relayState(String relayState) {
            this.relayState = relayState;
            return this._this();
        }

        public T samlRequest(String samlRequest) {
            this.samlRequest = samlRequest;
            return this._this();
        }

        public T authenticationRequestUri(String authenticationRequestUri) {
            this.authenticationRequestUri = authenticationRequestUri;
            return this._this();
        }
    }
}

