/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.metadata.AuthMetadataCodec;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.security.rsocket.metadata.BearerTokenMetadata;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class BearerTokenAuthenticationEncoder
extends AbstractEncoder<BearerTokenMetadata> {
    private static final MimeType AUTHENTICATION_MIME_TYPE = MimeTypeUtils.parseMimeType((String)"message/x.rsocket.authentication.v0");
    private NettyDataBufferFactory defaultBufferFactory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);

    public BearerTokenAuthenticationEncoder() {
        super(new MimeType[]{AUTHENTICATION_MIME_TYPE});
    }

    public Flux<DataBuffer> encode(Publisher<? extends BearerTokenMetadata> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(inputStream).map(credentials -> this.encodeValue((BearerTokenMetadata)credentials, bufferFactory, elementType, mimeType, hints));
    }

    public DataBuffer encodeValue(BearerTokenMetadata credentials, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        String token = credentials.getToken();
        NettyDataBufferFactory factory = this.nettyFactory(bufferFactory);
        ByteBufAllocator allocator = factory.getByteBufAllocator();
        ByteBuf simpleAuthentication = AuthMetadataCodec.encodeBearerMetadata((ByteBufAllocator)allocator, (char[])token.toCharArray());
        return factory.wrap(simpleAuthentication);
    }

    private NettyDataBufferFactory nettyFactory(DataBufferFactory bufferFactory) {
        if (bufferFactory instanceof NettyDataBufferFactory) {
            return (NettyDataBufferFactory)bufferFactory;
        }
        return this.defaultBufferFactory;
    }
}

