/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.core;

import java.util.List;
import java.util.ListIterator;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.api.PayloadInterceptorChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class ContextPayloadInterceptorChain
implements PayloadInterceptorChain {
    private final PayloadInterceptor currentInterceptor;
    private final ContextPayloadInterceptorChain next;
    private Context context;

    ContextPayloadInterceptorChain(List<PayloadInterceptor> interceptors) {
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors cannot be null");
        }
        if (interceptors.isEmpty()) {
            throw new IllegalArgumentException("interceptors cannot be empty");
        }
        ContextPayloadInterceptorChain interceptor = ContextPayloadInterceptorChain.init(interceptors);
        this.currentInterceptor = interceptor.currentInterceptor;
        this.next = interceptor.next;
    }

    private static ContextPayloadInterceptorChain init(List<PayloadInterceptor> interceptors) {
        ContextPayloadInterceptorChain interceptor = new ContextPayloadInterceptorChain(null, null);
        ListIterator<PayloadInterceptor> iterator = interceptors.listIterator(interceptors.size());
        while (iterator.hasPrevious()) {
            interceptor = new ContextPayloadInterceptorChain(iterator.previous(), interceptor);
        }
        return interceptor;
    }

    private ContextPayloadInterceptorChain(PayloadInterceptor currentInterceptor, ContextPayloadInterceptorChain next) {
        this.currentInterceptor = currentInterceptor;
        this.next = next;
    }

    @Override
    public Mono<Void> next(PayloadExchange exchange) {
        return Mono.defer(() -> this.shouldIntercept() ? this.currentInterceptor.intercept(exchange, this.next) : Mono.deferContextual(Mono::just).cast(Context.class).doOnNext(c -> {
            this.context = c;
        }).then());
    }

    Context getContext() {
        if (this.next == null) {
            return this.context;
        }
        return this.next.getContext();
    }

    private boolean shouldIntercept() {
        return this.currentInterceptor != null && this.next != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[currentInterceptor=" + String.valueOf(this.currentInterceptor) + "]";
    }
}

