/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeAuthorizationContext;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcher;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcherEntry;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PayloadExchangeMatcherReactiveAuthorizationManager
implements ReactiveAuthorizationManager<PayloadExchange> {
    private final List<PayloadExchangeMatcherEntry<ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>>> mappings;

    private PayloadExchangeMatcherReactiveAuthorizationManager(List<PayloadExchangeMatcherEntry<ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>>> mappings) {
        Assert.notEmpty(mappings, (String)"mappings cannot be null");
        this.mappings = mappings;
    }

    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, PayloadExchange exchange) {
        return Flux.fromIterable(this.mappings).concatMap(mapping -> mapping.getMatcher().matches(exchange).filter(PayloadExchangeMatcher.MatchResult::isMatch).map(PayloadExchangeMatcher.MatchResult::getVariables).flatMap(variables -> ((ReactiveAuthorizationManager)mapping.getEntry()).check(authentication, (Object)new PayloadExchangeAuthorizationContext(exchange, (Map<String, Object>)variables)))).next().switchIfEmpty(Mono.fromCallable(() -> new AuthorizationDecision(false)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<PayloadExchangeMatcherEntry<ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>>> mappings = new ArrayList<PayloadExchangeMatcherEntry<ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>>>();

        private Builder() {
        }

        public Builder add(PayloadExchangeMatcherEntry<ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>> entry) {
            this.mappings.add(entry);
            return this;
        }

        public PayloadExchangeMatcherReactiveAuthorizationManager build() {
            return new PayloadExchangeMatcherReactiveAuthorizationManager(this.mappings);
        }
    }
}

