/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;

public abstract class AbstractOAuth2TokenAuthenticationToken<T extends OAuth2Token>
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 620L;
    private Object principal;
    private Object credentials;
    private T token;

    protected AbstractOAuth2TokenAuthenticationToken(T token) {
        this(token, null);
    }

    protected AbstractOAuth2TokenAuthenticationToken(T token, Collection<? extends GrantedAuthority> authorities) {
        this(token, token, token, authorities);
    }

    protected AbstractOAuth2TokenAuthenticationToken(T token, Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        Assert.notNull(token, (String)"token cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        this.principal = principal;
        this.credentials = credentials;
        this.token = token;
    }

    protected AbstractOAuth2TokenAuthenticationToken(AbstractOAuth2TokenAuthenticationBuilder<T, ?> builder) {
        super(builder);
        Assert.notNull((Object)builder.credentials, (String)"token cannot be null");
        Assert.notNull((Object)builder.principal, (String)"principal cannot be null");
        this.principal = builder.principal;
        this.credentials = builder.credentials;
        this.token = builder.token;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public final T getToken() {
        return this.token;
    }

    public abstract Map<String, Object> getTokenAttributes();

    public static abstract class AbstractOAuth2TokenAuthenticationBuilder<T extends OAuth2Token, B extends AbstractOAuth2TokenAuthenticationBuilder<T, B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private Object principal;
        private Object credentials;
        private T token;

        protected AbstractOAuth2TokenAuthenticationBuilder(AbstractOAuth2TokenAuthenticationToken<T> token) {
            super(token);
            this.principal = token.getPrincipal();
            this.credentials = token.getCredentials();
            this.token = token.getToken();
        }

        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)((Object)this);
        }

        public B credentials(@Nullable Object credentials) {
            Assert.notNull((Object)credentials, (String)"credentials cannot be null");
            this.credentials = credentials;
            return (B)((Object)this);
        }

        public B token(T token) {
            Assert.notNull(token, (String)"token cannot be null");
            this.token = token;
            return (B)((Object)this);
        }
    }
}

