/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.oauth2.core.ClaimAccessor;

public interface OAuth2ProtectedResourceMetadataClaimAccessor
extends ClaimAccessor {
    default public URL getResource() {
        return this.getClaimAsURL("resource");
    }

    default public List<URL> getAuthorizationServers() {
        List authorizationServers = this.getClaimAsStringList("authorization_servers");
        ArrayList<URL> urls = new ArrayList<URL>();
        authorizationServers.forEach(authorizationServer -> {
            try {
                urls.add(new URI((String)authorizationServer).toURL());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to convert authorization_server to URL", ex);
            }
        });
        return urls;
    }

    default public List<String> getScopes() {
        return this.getClaimAsStringList("scopes_supported");
    }

    default public List<String> getBearerMethodsSupported() {
        return this.getClaimAsStringList("bearer_methods_supported");
    }

    default public String getResourceName() {
        return this.getClaimAsString("resource_name");
    }

    default public boolean isTlsClientCertificateBoundAccessTokens() {
        return Boolean.TRUE.equals(this.getClaimAsBoolean("tls_client_certificate_bound_access_tokens"));
    }
}

