/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URI;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;

public final class DPoPProofContext {
    private final String dPoPProof;
    private final String method;
    private final String targetUri;
    private final OAuth2Token accessToken;

    private DPoPProofContext(String dPoPProof, String method, String targetUri, @Nullable OAuth2Token accessToken) {
        this.dPoPProof = dPoPProof;
        this.method = method;
        this.targetUri = targetUri;
        this.accessToken = accessToken;
    }

    public String getDPoPProof() {
        return this.dPoPProof;
    }

    public String getMethod() {
        return this.method;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    @Nullable
    public <T extends OAuth2Token> T getAccessToken() {
        return (T)this.accessToken;
    }

    public static Builder withDPoPProof(String dPoPProof) {
        return new Builder(dPoPProof);
    }

    public static final class Builder {
        private String dPoPProof;
        private String method;
        private String targetUri;
        private OAuth2Token accessToken;

        private Builder(String dPoPProof) {
            Assert.hasText((String)dPoPProof, (String)"dPoPProof cannot be empty");
            this.dPoPProof = dPoPProof;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder targetUri(String targetUri) {
            this.targetUri = targetUri;
            return this;
        }

        public Builder accessToken(OAuth2Token accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public DPoPProofContext build() {
            this.validate();
            return new DPoPProofContext(this.dPoPProof, this.method, this.targetUri, this.accessToken);
        }

        private void validate() {
            URI uri;
            Assert.hasText((String)this.method, (String)"method cannot be empty");
            Assert.hasText((String)this.targetUri, (String)"targetUri cannot be empty");
            if (!("GET".equals(this.method) || "HEAD".equals(this.method) || "POST".equals(this.method) || "PUT".equals(this.method) || "PATCH".equals(this.method) || "DELETE".equals(this.method) || "OPTIONS".equals(this.method) || "TRACE".equals(this.method))) {
                throw new IllegalArgumentException("method is invalid");
            }
            try {
                uri = new URI(this.targetUri);
                uri.toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("targetUri must be a valid URL", ex);
            }
            if (uri.getQuery() != null || uri.getFragment() != null) {
                throw new IllegalArgumentException("targetUri cannot contain query or fragment parts");
            }
        }
    }
}

