/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.jwt.JwtClaimAccessor;
import org.springframework.util.Assert;

public class Jwt
extends AbstractOAuth2Token
implements JwtClaimAccessor {
    private final Map<String, Object> headers;
    private final Map<String, Object> claims;

    public Jwt(String tokenValue, Instant issuedAt, Instant expiresAt, Map<String, Object> headers, Map<String, Object> claims) {
        super(tokenValue, issuedAt, expiresAt);
        Assert.notEmpty(headers, (String)"headers cannot be empty");
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(headers));
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }
}

