/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequestUtils;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserSource;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OidcReactiveOAuth2UserService
implements ReactiveOAuth2UserService<OidcUserRequest, OidcUser> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private static final Converter<Map<String, Object>, Map<String, Object>> DEFAULT_CLAIM_TYPE_CONVERTER = new ClaimTypeConverter(OidcReactiveOAuth2UserService.createDefaultClaimTypeConverters());
    private ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService = new DefaultReactiveOAuth2UserService();
    private Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory = clientRegistration -> DEFAULT_CLAIM_TYPE_CONVERTER;
    private Predicate<OidcUserRequest> retrieveUserInfo = OidcUserRequestUtils::shouldRetrieveUserInfo;
    private Converter<OidcUserSource, Mono<OidcUser>> oidcUserConverter = source -> Mono.just((Object)OidcUserRequestUtils.getUser(source));

    public static Map<String, Converter<Object, ?>> createDefaultClaimTypeConverters() {
        Converter<Object, ?> booleanConverter = OidcReactiveOAuth2UserService.getConverter(TypeDescriptor.valueOf(Boolean.class));
        Converter<Object, ?> instantConverter = OidcReactiveOAuth2UserService.getConverter(TypeDescriptor.valueOf(Instant.class));
        HashMap claimTypeConverters = new HashMap();
        claimTypeConverters.put("email_verified", booleanConverter);
        claimTypeConverters.put("phone_number_verified", booleanConverter);
        claimTypeConverters.put("updated_at", instantConverter);
        return claimTypeConverters;
    }

    private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
        TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(Object.class);
        return source -> ClaimConversionService.getSharedInstance().convert(source, sourceDescriptor, targetDescriptor);
    }

    @Override
    public Mono<OidcUser> loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        return Mono.just((Object)userRequest).filter(this.retrieveUserInfo::test).flatMap(this.oauth2UserService::loadUser).flatMap(oauth2User -> this.toOidcUser(userRequest, (OAuth2User)oauth2User)).switchIfEmpty(Mono.defer(() -> (Mono)this.oidcUserConverter.convert((Object)new OidcUserSource(userRequest))));
    }

    private Mono<OidcUser> toOidcUser(OidcUserRequest userRequest, OAuth2User oauth2User) {
        return Mono.defer(() -> {
            Map<String, Object> claims = this.convertClaims(oauth2User.getAttributes(), userRequest.getClientRegistration());
            OidcUserInfo userInfo = new OidcUserInfo(claims);
            String subject = userInfo.getSubject();
            if (subject == null || !subject.equals(userRequest.getIdToken().getSubject())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            OidcUserSource source = new OidcUserSource(userRequest, userInfo, oauth2User);
            return (Mono)this.oidcUserConverter.convert((Object)source);
        });
    }

    private Map<String, Object> convertClaims(Map<String, Object> claims, ClientRegistration clientRegistration) {
        Converter<Map<String, Object>, Map<String, Object>> claimTypeConverter = this.claimTypeConverterFactory.apply(clientRegistration);
        return claimTypeConverter != null ? (Map)claimTypeConverter.convert(claims) : (Map)DEFAULT_CLAIM_TYPE_CONVERTER.convert(claims);
    }

    public void setOauth2UserService(ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService) {
        Assert.notNull(oauth2UserService, (String)"oauth2UserService cannot be null");
        this.oauth2UserService = oauth2UserService;
    }

    public final void setClaimTypeConverterFactory(Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory) {
        Assert.notNull(claimTypeConverterFactory, (String)"claimTypeConverterFactory cannot be null");
        this.claimTypeConverterFactory = claimTypeConverterFactory;
    }

    public final void setRetrieveUserInfo(Predicate<OidcUserRequest> retrieveUserInfo) {
        Assert.notNull(retrieveUserInfo, (String)"retrieveUserInfo cannot be null");
        this.retrieveUserInfo = retrieveUserInfo;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public final void setOidcUserMapper(BiFunction<OidcUserRequest, OidcUserInfo, Mono<OidcUser>> oidcUserMapper) {
        Assert.notNull(oidcUserMapper, (String)"oidcUserMapper cannot be null");
        this.oidcUserConverter = source -> (Mono)oidcUserMapper.apply(source.getUserRequest(), source.getUserInfo());
    }

    public void setOidcUserConverter(Converter<OidcUserSource, Mono<OidcUser>> oidcUserConverter) {
        Assert.notNull(oidcUserConverter, (String)"oidcUserConverter cannot be null");
        this.oidcUserConverter = oidcUserConverter;
    }
}

