/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ClientRegistration
implements Serializable {
    private static final long serialVersionUID = 620L;
    private String registrationId;
    private String clientId;
    private String clientSecret;
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private AuthorizationGrantType authorizationGrantType;
    private String redirectUri;
    private Set<String> scopes = Collections.emptySet();
    private ProviderDetails providerDetails = new ProviderDetails();
    private String clientName;

    private ClientRegistration() {
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public ProviderDetails getProviderDetails() {
        return this.providerDetails;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String toString() {
        return "ClientRegistration{registrationId='" + this.registrationId + "', clientId='" + this.clientId + "', clientSecret='" + this.clientSecret + "', clientAuthenticationMethod=" + String.valueOf(this.clientAuthenticationMethod) + ", authorizationGrantType=" + String.valueOf(this.authorizationGrantType) + ", redirectUri='" + this.redirectUri + "', scopes=" + String.valueOf(this.scopes) + ", providerDetails=" + String.valueOf(this.providerDetails) + ", clientName='" + this.clientName + "'}";
    }

    public static Builder withRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return new Builder(registrationId);
    }

    public static Builder withClientRegistration(ClientRegistration clientRegistration) {
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        return new Builder(clientRegistration);
    }

    public class ProviderDetails
    implements Serializable {
        private static final long serialVersionUID = 620L;
        private String authorizationUri;
        private String tokenUri;
        private UserInfoEndpoint userInfoEndpoint = new UserInfoEndpoint();
        private String jwkSetUri;
        private String issuerUri;
        private Map<String, Object> configurationMetadata = Collections.emptyMap();

        ProviderDetails() {
        }

        public String getAuthorizationUri() {
            return this.authorizationUri;
        }

        public String getTokenUri() {
            return this.tokenUri;
        }

        public UserInfoEndpoint getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        public String getJwkSetUri() {
            return this.jwkSetUri;
        }

        public String getIssuerUri() {
            return this.issuerUri;
        }

        public Map<String, Object> getConfigurationMetadata() {
            return this.configurationMetadata;
        }

        public class UserInfoEndpoint
        implements Serializable {
            private static final long serialVersionUID = 620L;
            private String uri;
            private AuthenticationMethod authenticationMethod = AuthenticationMethod.HEADER;
            private String userNameAttributeName;

            UserInfoEndpoint() {
            }

            public String getUri() {
                return this.uri;
            }

            public AuthenticationMethod getAuthenticationMethod() {
                return this.authenticationMethod;
            }

            public String getUserNameAttributeName() {
                return this.userNameAttributeName;
            }
        }
    }

    public static final class Builder
    implements Serializable {
        private static final long serialVersionUID = 620L;
        private static final Log logger = LogFactory.getLog(Builder.class);
        private static final List<AuthorizationGrantType> AUTHORIZATION_GRANT_TYPES = Arrays.asList(AuthorizationGrantType.AUTHORIZATION_CODE, AuthorizationGrantType.CLIENT_CREDENTIALS, AuthorizationGrantType.REFRESH_TOKEN, AuthorizationGrantType.PASSWORD);
        private String registrationId;
        private String clientId;
        private String clientSecret;
        private ClientAuthenticationMethod clientAuthenticationMethod;
        private AuthorizationGrantType authorizationGrantType;
        private String redirectUri;
        private Set<String> scopes;
        private String authorizationUri;
        private String tokenUri;
        private String userInfoUri;
        private AuthenticationMethod userInfoAuthenticationMethod = AuthenticationMethod.HEADER;
        private String userNameAttributeName;
        private String jwkSetUri;
        private String issuerUri;
        private Map<String, Object> configurationMetadata = Collections.emptyMap();
        private String clientName;

        private Builder(String registrationId) {
            this.registrationId = registrationId;
        }

        private Builder(ClientRegistration clientRegistration) {
            this.registrationId = clientRegistration.registrationId;
            this.clientId = clientRegistration.clientId;
            this.clientSecret = clientRegistration.clientSecret;
            this.clientAuthenticationMethod = clientRegistration.clientAuthenticationMethod;
            this.authorizationGrantType = clientRegistration.authorizationGrantType;
            this.redirectUri = clientRegistration.redirectUri;
            this.scopes = clientRegistration.scopes != null ? new HashSet<String>(clientRegistration.scopes) : null;
            this.authorizationUri = clientRegistration.providerDetails.authorizationUri;
            this.tokenUri = clientRegistration.providerDetails.tokenUri;
            this.userInfoUri = clientRegistration.providerDetails.userInfoEndpoint.uri;
            this.userInfoAuthenticationMethod = clientRegistration.providerDetails.userInfoEndpoint.authenticationMethod;
            this.userNameAttributeName = clientRegistration.providerDetails.userInfoEndpoint.userNameAttributeName;
            this.jwkSetUri = clientRegistration.providerDetails.jwkSetUri;
            this.issuerUri = clientRegistration.providerDetails.issuerUri;
            Map<String, Object> configurationMetadata = clientRegistration.providerDetails.configurationMetadata;
            if (configurationMetadata != Collections.EMPTY_MAP) {
                this.configurationMetadata = new HashMap<String, Object>(configurationMetadata);
            }
            this.clientName = clientRegistration.clientName;
        }

        public Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder clientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
            this.clientAuthenticationMethod = clientAuthenticationMethod;
            return this;
        }

        public Builder authorizationGrantType(AuthorizationGrantType authorizationGrantType) {
            this.authorizationGrantType = authorizationGrantType;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder scope(String ... scope) {
            if (scope != null && scope.length > 0) {
                this.scopes = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(scope)));
            }
            return this;
        }

        public Builder scope(Collection<String> scope) {
            if (scope != null && !scope.isEmpty()) {
                this.scopes = Collections.unmodifiableSet(new LinkedHashSet<String>(scope));
            }
            return this;
        }

        public Builder authorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
            return this;
        }

        public Builder tokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
            return this;
        }

        public Builder userInfoUri(String userInfoUri) {
            this.userInfoUri = userInfoUri;
            return this;
        }

        public Builder userInfoAuthenticationMethod(AuthenticationMethod userInfoAuthenticationMethod) {
            this.userInfoAuthenticationMethod = userInfoAuthenticationMethod;
            return this;
        }

        public Builder userNameAttributeName(String userNameAttributeName) {
            this.userNameAttributeName = userNameAttributeName;
            return this;
        }

        public Builder jwkSetUri(String jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
            return this;
        }

        public Builder issuerUri(String issuerUri) {
            this.issuerUri = issuerUri;
            return this;
        }

        public Builder providerConfigurationMetadata(Map<String, Object> configurationMetadata) {
            if (configurationMetadata != null) {
                this.configurationMetadata = new LinkedHashMap<String, Object>(configurationMetadata);
            }
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public ClientRegistration build() {
            Assert.notNull((Object)this.authorizationGrantType, (String)"authorizationGrantType cannot be null");
            if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)this.authorizationGrantType)) {
                this.validateClientCredentialsGrantType();
            } else if (AuthorizationGrantType.PASSWORD.equals((Object)this.authorizationGrantType)) {
                this.validatePasswordGrantType();
            } else if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)this.authorizationGrantType)) {
                this.validateAuthorizationCodeGrantType();
            }
            this.validateAuthorizationGrantTypes();
            this.validateScopes();
            return this.create();
        }

        private ClientRegistration create() {
            ClientRegistration clientRegistration = new ClientRegistration();
            clientRegistration.registrationId = this.registrationId;
            clientRegistration.clientId = this.clientId;
            clientRegistration.clientSecret = StringUtils.hasText((String)this.clientSecret) ? this.clientSecret : "";
            clientRegistration.clientAuthenticationMethod = this.clientAuthenticationMethod != null ? this.clientAuthenticationMethod : this.deduceClientAuthenticationMethod(clientRegistration);
            clientRegistration.authorizationGrantType = this.authorizationGrantType;
            clientRegistration.redirectUri = this.redirectUri;
            clientRegistration.scopes = this.scopes;
            clientRegistration.providerDetails = this.createProviderDetails(clientRegistration);
            clientRegistration.clientName = StringUtils.hasText((String)this.clientName) ? this.clientName : this.registrationId;
            return clientRegistration;
        }

        private ClientAuthenticationMethod deduceClientAuthenticationMethod(ClientRegistration clientRegistration) {
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)this.authorizationGrantType) && !StringUtils.hasText((String)this.clientSecret)) {
                return ClientAuthenticationMethod.NONE;
            }
            return ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
        }

        private ProviderDetails createProviderDetails(ClientRegistration clientRegistration) {
            ProviderDetails providerDetails = clientRegistration.new ProviderDetails();
            providerDetails.authorizationUri = this.authorizationUri;
            providerDetails.tokenUri = this.tokenUri;
            providerDetails.userInfoEndpoint.uri = this.userInfoUri;
            providerDetails.userInfoEndpoint.authenticationMethod = this.userInfoAuthenticationMethod;
            providerDetails.userInfoEndpoint.userNameAttributeName = this.userNameAttributeName;
            providerDetails.jwkSetUri = this.jwkSetUri;
            providerDetails.issuerUri = this.issuerUri;
            providerDetails.configurationMetadata = Collections.unmodifiableMap(this.configurationMetadata);
            return providerDetails;
        }

        private void validateAuthorizationCodeGrantType() {
            Assert.isTrue((boolean)AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)this.authorizationGrantType), () -> "authorizationGrantType must be " + AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
            Assert.hasText((String)this.registrationId, (String)"registrationId cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            Assert.hasText((String)this.redirectUri, (String)"redirectUri cannot be empty");
            Assert.hasText((String)this.authorizationUri, (String)"authorizationUri cannot be empty");
            Assert.hasText((String)this.tokenUri, (String)"tokenUri cannot be empty");
        }

        private void validateClientCredentialsGrantType() {
            Assert.isTrue((boolean)AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)this.authorizationGrantType), () -> "authorizationGrantType must be " + AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
            Assert.hasText((String)this.registrationId, (String)"registrationId cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            Assert.hasText((String)this.tokenUri, (String)"tokenUri cannot be empty");
        }

        private void validatePasswordGrantType() {
            Assert.isTrue((boolean)AuthorizationGrantType.PASSWORD.equals((Object)this.authorizationGrantType), () -> "authorizationGrantType must be " + AuthorizationGrantType.PASSWORD.getValue());
            Assert.hasText((String)this.registrationId, (String)"registrationId cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            Assert.hasText((String)this.tokenUri, (String)"tokenUri cannot be empty");
        }

        private void validateAuthorizationGrantTypes() {
            for (AuthorizationGrantType authorizationGrantType : AUTHORIZATION_GRANT_TYPES) {
                if (!authorizationGrantType.getValue().equalsIgnoreCase(this.authorizationGrantType.getValue()) || authorizationGrantType.equals((Object)this.authorizationGrantType)) continue;
                logger.warn((Object)LogMessage.format((String)"AuthorizationGrantType: %s does not match the pre-defined constant %s and won't match a valid OAuth2AuthorizedClientProvider", (Object)this.authorizationGrantType, (Object)authorizationGrantType));
            }
        }

        private void validateScopes() {
            if (this.scopes == null) {
                return;
            }
            for (String scope : this.scopes) {
                Assert.isTrue((boolean)Builder.validateScope(scope), (String)("scope \"" + scope + "\" contains invalid characters"));
            }
        }

        private static boolean validateScope(String scope) {
            return scope == null || scope.chars().allMatch(c -> Builder.withinTheRangeOf(c, 33, 33) || Builder.withinTheRangeOf(c, 35, 91) || Builder.withinTheRangeOf(c, 93, 126));
        }

        private static boolean withinTheRangeOf(int c, int min, int max) {
            return c >= min && c <= max;
        }
    }
}

