/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.authentication;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OAuth2LoginReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ReactiveAuthenticationManager authorizationCodeManager;
    private final ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> userService;
    private GrantedAuthoritiesMapper authoritiesMapper = authorities -> authorities;

    public OAuth2LoginReactiveAuthenticationManager(ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient, ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> userService) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        Assert.notNull(userService, (String)"userService cannot be null");
        this.authorizationCodeManager = new OAuth2AuthorizationCodeReactiveAuthenticationManager(accessTokenResponseClient);
        this.userService = userService;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.defer(() -> {
            OAuth2AuthorizationCodeAuthenticationToken token = (OAuth2AuthorizationCodeAuthenticationToken)authentication;
            if (token.getAuthorizationExchange().getAuthorizationRequest().getScopes().contains("openid")) {
                return Mono.empty();
            }
            return this.authorizationCodeManager.authenticate((Authentication)token).onErrorMap(OAuth2AuthorizationException.class, e -> new OAuth2AuthenticationException(e.getError(), e.getError().toString())).cast(OAuth2AuthorizationCodeAuthenticationToken.class).flatMap(this::onSuccess);
        });
    }

    public final void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        Assert.notNull((Object)authoritiesMapper, (String)"authoritiesMapper cannot be null");
        this.authoritiesMapper = authoritiesMapper;
    }

    private Mono<OAuth2LoginAuthenticationToken> onSuccess(OAuth2AuthorizationCodeAuthenticationToken authentication) {
        OAuth2AccessToken accessToken = authentication.getAccessToken();
        Map<String, Object> additionalParameters = authentication.getAdditionalParameters();
        OAuth2UserRequest userRequest = new OAuth2UserRequest(authentication.getClientRegistration(), accessToken, additionalParameters);
        return this.userService.loadUser(userRequest).map(oauth2User -> {
            Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oauth2User.getAuthorities());
            OAuth2LoginAuthenticationToken authenticationResult = new OAuth2LoginAuthenticationToken(authentication.getClientRegistration(), authentication.getAuthorizationExchange(), (OAuth2User)oauth2User, mappedAuthorities, accessToken, authentication.getRefreshToken());
            return authenticationResult;
        });
    }
}

