/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public final class ServletOAuth2AuthorizedClientExchangeFilterFunction
implements ExchangeFilterFunction {
    static final String SECURITY_REACTOR_CONTEXT_ATTRIBUTES_KEY = "org.springframework.security.SECURITY_CONTEXT_ATTRIBUTES";
    private static final String OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME = OAuth2AuthorizedClient.class.getName();
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = OAuth2AuthorizedClient.class.getName().concat(".CLIENT_REGISTRATION_ID");
    private static final String AUTHENTICATION_ATTR_NAME = Authentication.class.getName();
    private static final String HTTP_SERVLET_REQUEST_ATTR_NAME = HttpServletRequest.class.getName();
    private static final String HTTP_SERVLET_RESPONSE_ATTR_NAME = HttpServletResponse.class.getName();
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    @Deprecated
    private Duration accessTokenExpiresSkew = Duration.ofMinutes(1L);
    @Deprecated
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    private OAuth2AuthorizedClientManager authorizedClientManager;
    private boolean defaultAuthorizedClientManager;
    private boolean defaultOAuth2AuthorizedClient;
    private String defaultClientRegistrationId;
    private ClientResponseHandler clientResponseHandler;

    public ServletOAuth2AuthorizedClientExchangeFilterFunction() {
    }

    public ServletOAuth2AuthorizedClientExchangeFilterFunction(OAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
        this.clientResponseHandler = (request, responseMono) -> responseMono;
    }

    public ServletOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        RemoveAuthorizedClientOAuth2AuthorizationFailureHandler authorizationFailureHandler = new RemoveAuthorizedClientOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> authorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, (HttpServletRequest)attributes.get(HttpServletRequest.class.getName()), (HttpServletResponse)attributes.get(HttpServletResponse.class.getName())));
        DefaultOAuth2AuthorizedClientManager defaultAuthorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        defaultAuthorizedClientManager.setAuthorizationFailureHandler(authorizationFailureHandler);
        this.authorizedClientManager = defaultAuthorizedClientManager;
        this.defaultAuthorizedClientManager = true;
        this.clientResponseHandler = new AuthorizationFailureForwarder(authorizationFailureHandler);
    }

    @Deprecated
    public void setClientCredentialsTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        Assert.notNull(clientCredentialsTokenResponseClient, (String)"clientCredentialsTokenResponseClient cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The client cannot be set when the constructor used is \"ServletOAuth2AuthorizedClientExchangeFilterFunction(OAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServletOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
        this.updateDefaultAuthorizedClientManager();
    }

    private void updateDefaultAuthorizedClientManager() {
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).clientCredentials(this::updateClientCredentialsProvider).password(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).build();
        ((DefaultOAuth2AuthorizedClientManager)this.authorizedClientManager).setAuthorizedClientProvider(authorizedClientProvider);
    }

    private void updateClientCredentialsProvider(OAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder builder) {
        if (this.clientCredentialsTokenResponseClient != null) {
            builder.accessTokenResponseClient(this.clientCredentialsTokenResponseClient);
        }
        builder.clockSkew(this.accessTokenExpiresSkew);
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.defaultOAuth2AuthorizedClient = defaultOAuth2AuthorizedClient;
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.defaultClientRegistrationId = clientRegistrationId;
    }

    public Consumer<WebClient.Builder> oauth2Configuration() {
        return builder -> builder.defaultRequest(this.defaultRequest()).filter((ExchangeFilterFunction)this);
    }

    public Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest() {
        return spec -> spec.attributes(attrs -> {
            this.populateDefaultRequestResponse((Map<String, Object>)attrs);
            this.populateDefaultAuthentication((Map<String, Object>)attrs);
        });
    }

    public static Consumer<Map<String, Object>> oauth2AuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return attributes -> {
            if (authorizedClient == null) {
                attributes.remove(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
            } else {
                attributes.put(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME, authorizedClient);
            }
        };
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }

    public static Consumer<Map<String, Object>> authentication(Authentication authentication) {
        return attributes -> attributes.put(AUTHENTICATION_ATTR_NAME, authentication);
    }

    public static Consumer<Map<String, Object>> httpServletRequest(HttpServletRequest request) {
        return attributes -> attributes.put(HTTP_SERVLET_REQUEST_ATTR_NAME, request);
    }

    public static Consumer<Map<String, Object>> httpServletResponse(HttpServletResponse response) {
        return attributes -> attributes.put(HTTP_SERVLET_RESPONSE_ATTR_NAME, response);
    }

    @Deprecated
    public void setAccessTokenExpiresSkew(Duration accessTokenExpiresSkew) {
        Assert.notNull((Object)accessTokenExpiresSkew, (String)"accessTokenExpiresSkew cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The accessTokenExpiresSkew cannot be set when the constructor used is \"ServletOAuth2AuthorizedClientExchangeFilterFunction(OAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServletOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.accessTokenExpiresSkew = accessTokenExpiresSkew;
        this.updateDefaultAuthorizedClientManager();
    }

    public void setAuthorizationFailureHandler(OAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
        this.clientResponseHandler = new AuthorizationFailureForwarder(authorizationFailureHandler);
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.mergeRequestAttributesIfNecessary(request).filter(req -> req.attribute(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME).isPresent()).flatMap(req -> this.reauthorizeClient(ServletOAuth2AuthorizedClientExchangeFilterFunction.getOAuth2AuthorizedClient(req.attributes()), (ClientRequest)req)).switchIfEmpty(Mono.defer(() -> this.mergeRequestAttributesIfNecessary(request).filter(req -> this.resolveClientRegistrationId((ClientRequest)req) != null).flatMap(req -> this.authorizeClient(this.resolveClientRegistrationId((ClientRequest)req), (ClientRequest)req)))).map(authorizedClient -> this.bearer(request, (OAuth2AuthorizedClient)authorizedClient)).flatMap(requestWithBearer -> this.exchangeAndHandleResponse((ClientRequest)requestWithBearer, next)).switchIfEmpty(Mono.defer(() -> this.exchangeAndHandleResponse(request, next)));
    }

    private Mono<ClientResponse> exchangeAndHandleResponse(ClientRequest request, ExchangeFunction next) {
        return next.exchange(request).transform(responseMono -> this.clientResponseHandler.handleResponse(request, (Mono<ClientResponse>)responseMono));
    }

    private Mono<ClientRequest> mergeRequestAttributesIfNecessary(ClientRequest request) {
        if (!(request.attribute(HTTP_SERVLET_REQUEST_ATTR_NAME).isPresent() && request.attribute(HTTP_SERVLET_RESPONSE_ATTR_NAME).isPresent() && request.attribute(AUTHENTICATION_ATTR_NAME).isPresent())) {
            return this.mergeRequestAttributesFromContext(request);
        }
        return Mono.just((Object)request);
    }

    private Mono<ClientRequest> mergeRequestAttributesFromContext(ClientRequest request) {
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)request);
        return Mono.subscriberContext().map(ctx -> builder.attributes(attrs -> this.populateRequestAttributes((Map<String, Object>)attrs, (Context)ctx))).map(ClientRequest.Builder::build);
    }

    private void populateRequestAttributes(Map<String, Object> attrs, Context ctx) {
        Authentication authentication;
        HttpServletResponse servletResponse;
        if (!ctx.hasKey((Object)SECURITY_REACTOR_CONTEXT_ATTRIBUTES_KEY)) {
            return;
        }
        Map contextAttributes = (Map)ctx.get((Object)SECURITY_REACTOR_CONTEXT_ATTRIBUTES_KEY);
        HttpServletRequest servletRequest = (HttpServletRequest)contextAttributes.get(HttpServletRequest.class);
        if (servletRequest != null) {
            attrs.putIfAbsent(HTTP_SERVLET_REQUEST_ATTR_NAME, servletRequest);
        }
        if ((servletResponse = (HttpServletResponse)contextAttributes.get(HttpServletResponse.class)) != null) {
            attrs.putIfAbsent(HTTP_SERVLET_RESPONSE_ATTR_NAME, servletResponse);
        }
        if ((authentication = (Authentication)contextAttributes.get(Authentication.class)) != null) {
            attrs.putIfAbsent(AUTHENTICATION_ATTR_NAME, authentication);
        }
    }

    private void populateDefaultRequestResponse(Map<String, Object> attrs) {
        if (attrs.containsKey(HTTP_SERVLET_REQUEST_ATTR_NAME) && attrs.containsKey(HTTP_SERVLET_RESPONSE_ATTR_NAME)) {
            return;
        }
        RequestAttributes context = RequestContextHolder.getRequestAttributes();
        if (context instanceof ServletRequestAttributes) {
            attrs.putIfAbsent(HTTP_SERVLET_REQUEST_ATTR_NAME, ((ServletRequestAttributes)context).getRequest());
            attrs.putIfAbsent(HTTP_SERVLET_RESPONSE_ATTR_NAME, ((ServletRequestAttributes)context).getResponse());
        }
    }

    private void populateDefaultAuthentication(Map<String, Object> attrs) {
        if (attrs.containsKey(AUTHENTICATION_ATTR_NAME)) {
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        attrs.putIfAbsent(AUTHENTICATION_ATTR_NAME, authentication);
    }

    private String resolveClientRegistrationId(ClientRequest request) {
        Map attrs = request.attributes();
        String clientRegistrationId = ServletOAuth2AuthorizedClientExchangeFilterFunction.getClientRegistrationId(attrs);
        if (clientRegistrationId == null) {
            clientRegistrationId = this.defaultClientRegistrationId;
        }
        Authentication authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.getAuthentication(attrs);
        if (clientRegistrationId == null && this.defaultOAuth2AuthorizedClient && authentication instanceof OAuth2AuthenticationToken) {
            clientRegistrationId = ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId();
        }
        return clientRegistrationId;
    }

    private Mono<OAuth2AuthorizedClient> authorizeClient(String clientRegistrationId, ClientRequest request) {
        if (this.authorizedClientManager == null) {
            return Mono.empty();
        }
        Map attrs = request.attributes();
        Authentication authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.getAuthentication(attrs);
        if (authentication == null) {
            authentication = ANONYMOUS_AUTHENTICATION;
        }
        HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
        HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
        OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withClientRegistrationId(clientRegistrationId).principal(authentication);
        builder.attributes(attributes -> {
            if (servletRequest != null) {
                attributes.put(HttpServletRequest.class.getName(), servletRequest);
            }
            if (servletResponse != null) {
                attributes.put(HttpServletResponse.class.getName(), servletResponse);
            }
        });
        OAuth2AuthorizeRequest authorizeRequest = builder.build();
        return Mono.fromSupplier(() -> this.authorizedClientManager.authorize(authorizeRequest)).subscribeOn(Schedulers.boundedElastic());
    }

    private Mono<OAuth2AuthorizedClient> reauthorizeClient(OAuth2AuthorizedClient authorizedClient, ClientRequest request) {
        if (this.authorizedClientManager == null) {
            return Mono.just((Object)authorizedClient);
        }
        Map attrs = request.attributes();
        Authentication authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.getAuthentication(attrs);
        if (authentication == null) {
            authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.createAuthentication(authorizedClient.getPrincipalName());
        }
        HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
        HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
        OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withAuthorizedClient(authorizedClient).principal(authentication);
        builder.attributes(attributes -> {
            if (servletRequest != null) {
                attributes.put(HttpServletRequest.class.getName(), servletRequest);
            }
            if (servletResponse != null) {
                attributes.put(HttpServletResponse.class.getName(), servletResponse);
            }
        });
        OAuth2AuthorizeRequest reauthorizeRequest = builder.build();
        return Mono.fromSupplier(() -> this.authorizedClientManager.authorize(reauthorizeRequest)).subscribeOn(Schedulers.boundedElastic());
    }

    private ClientRequest bearer(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(authorizedClient.getAccessToken().getTokenValue())).attributes(ServletOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(authorizedClient)).build();
    }

    static OAuth2AuthorizedClient getOAuth2AuthorizedClient(Map<String, Object> attrs) {
        return (OAuth2AuthorizedClient)attrs.get(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
    }

    static String getClientRegistrationId(Map<String, Object> attrs) {
        return (String)attrs.get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    static Authentication getAuthentication(Map<String, Object> attrs) {
        return (Authentication)attrs.get(AUTHENTICATION_ATTR_NAME);
    }

    static HttpServletRequest getRequest(Map<String, Object> attrs) {
        return (HttpServletRequest)attrs.get(HTTP_SERVLET_REQUEST_ATTR_NAME);
    }

    static HttpServletResponse getResponse(Map<String, Object> attrs) {
        return (HttpServletResponse)attrs.get(HTTP_SERVLET_RESPONSE_ATTR_NAME);
    }

    private static Authentication createAuthentication(final String principalName) {
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        return new AbstractAuthenticationToken(null){

            public Object getCredentials() {
                return "";
            }

            public Object getPrincipal() {
                return principalName;
            }
        };
    }

    private static class AuthorizationFailureForwarder
    implements ClientResponseHandler {
        private final Map<Integer, String> httpStatusToOAuth2ErrorCodeMap;
        private final OAuth2AuthorizationFailureHandler authorizationFailureHandler;

        private AuthorizationFailureForwarder(OAuth2AuthorizationFailureHandler authorizationFailureHandler) {
            Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
            this.authorizationFailureHandler = authorizationFailureHandler;
            HashMap<Integer, String> httpStatusToOAuth2Error = new HashMap<Integer, String>();
            httpStatusToOAuth2Error.put(HttpStatus.UNAUTHORIZED.value(), "invalid_token");
            httpStatusToOAuth2Error.put(HttpStatus.FORBIDDEN.value(), "insufficient_scope");
            this.httpStatusToOAuth2ErrorCodeMap = Collections.unmodifiableMap(httpStatusToOAuth2Error);
        }

        @Override
        public Mono<ClientResponse> handleResponse(ClientRequest request, Mono<ClientResponse> responseMono) {
            return responseMono.flatMap(response -> this.handleResponse(request, (ClientResponse)response).thenReturn(response)).onErrorResume(WebClientResponseException.class, e -> this.handleWebClientResponseException(request, (WebClientResponseException)e).then(Mono.error((Throwable)e))).onErrorResume(OAuth2AuthorizationException.class, e -> this.handleAuthorizationException(request, (OAuth2AuthorizationException)((Object)e)).then(Mono.error((Throwable)e)));
        }

        private Mono<Void> handleResponse(ClientRequest request, ClientResponse response) {
            return Mono.justOrEmpty((Object)this.resolveErrorIfPossible(response)).flatMap(oauth2Error -> {
                Map attrs = request.attributes();
                OAuth2AuthorizedClient authorizedClient = ServletOAuth2AuthorizedClientExchangeFilterFunction.getOAuth2AuthorizedClient(attrs);
                if (authorizedClient == null) {
                    return Mono.empty();
                }
                ClientAuthorizationException authorizationException = new ClientAuthorizationException((OAuth2Error)oauth2Error, authorizedClient.getClientRegistration().getRegistrationId());
                Authentication principal = ServletOAuth2AuthorizedClientExchangeFilterFunction.createAuthentication(authorizedClient.getPrincipalName());
                HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
                HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
                return this.handleAuthorizationFailure(authorizationException, principal, servletRequest, servletResponse);
            });
        }

        private OAuth2Error resolveErrorIfPossible(ClientResponse response) {
            String wwwAuthenticateHeader;
            Map<String, String> authParameters;
            if (!response.headers().header("WWW-Authenticate").isEmpty() && (authParameters = this.parseAuthParameters(wwwAuthenticateHeader = (String)response.headers().header("WWW-Authenticate").get(0))).containsKey("error")) {
                return new OAuth2Error(authParameters.get("error"), authParameters.get("error_description"), authParameters.get("error_uri"));
            }
            return this.resolveErrorIfPossible(response.rawStatusCode());
        }

        private OAuth2Error resolveErrorIfPossible(int statusCode) {
            if (this.httpStatusToOAuth2ErrorCodeMap.containsKey(statusCode)) {
                return new OAuth2Error(this.httpStatusToOAuth2ErrorCodeMap.get(statusCode), null, "https://tools.ietf.org/html/rfc6750#section-3.1");
            }
            return null;
        }

        private Map<String, String> parseAuthParameters(String wwwAuthenticateHeader) {
            return Stream.of(wwwAuthenticateHeader).filter(header -> !StringUtils.isEmpty((Object)header)).filter(header -> header.toLowerCase().startsWith("bearer")).map(header -> header.substring("bearer".length())).map(header -> header.split(",")).flatMap(Stream::of).map(parameter -> parameter.split("=")).filter(parameter -> ((String[])parameter).length > 1).collect(Collectors.toMap(parameters -> parameters[0].trim(), parameters -> parameters[1].trim().replace("\"", "")));
        }

        private Mono<Void> handleWebClientResponseException(ClientRequest request, WebClientResponseException exception) {
            return Mono.justOrEmpty((Object)this.resolveErrorIfPossible(exception.getRawStatusCode())).flatMap(oauth2Error -> {
                Map attrs = request.attributes();
                OAuth2AuthorizedClient authorizedClient = ServletOAuth2AuthorizedClientExchangeFilterFunction.getOAuth2AuthorizedClient(attrs);
                if (authorizedClient == null) {
                    return Mono.empty();
                }
                ClientAuthorizationException authorizationException = new ClientAuthorizationException((OAuth2Error)oauth2Error, authorizedClient.getClientRegistration().getRegistrationId(), (Throwable)exception);
                Authentication principal = ServletOAuth2AuthorizedClientExchangeFilterFunction.createAuthentication(authorizedClient.getPrincipalName());
                HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
                HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
                return this.handleAuthorizationFailure(authorizationException, principal, servletRequest, servletResponse);
            });
        }

        private Mono<Void> handleAuthorizationException(ClientRequest request, OAuth2AuthorizationException authorizationException) {
            return Mono.justOrEmpty((Object)request).flatMap(req -> {
                Map attrs = req.attributes();
                OAuth2AuthorizedClient authorizedClient = ServletOAuth2AuthorizedClientExchangeFilterFunction.getOAuth2AuthorizedClient(attrs);
                if (authorizedClient == null) {
                    return Mono.empty();
                }
                Authentication principal = ServletOAuth2AuthorizedClientExchangeFilterFunction.createAuthentication(authorizedClient.getPrincipalName());
                HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
                HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
                return this.handleAuthorizationFailure(authorizationException, principal, servletRequest, servletResponse);
            });
        }

        private Mono<Void> handleAuthorizationFailure(OAuth2AuthorizationException exception, Authentication principal, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
            Runnable runnable = () -> this.authorizationFailureHandler.onAuthorizationFailure(exception, principal, AuthorizationFailureForwarder.createAttributes(servletRequest, servletResponse));
            return Mono.fromRunnable((Runnable)runnable).subscribeOn(Schedulers.boundedElastic()).then();
        }

        private static Map<String, Object> createAttributes(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(HttpServletRequest.class.getName(), servletRequest);
            attributes.put(HttpServletResponse.class.getName(), servletResponse);
            return attributes;
        }
    }

    @FunctionalInterface
    private static interface ClientResponseHandler {
        public Mono<ClientResponse> handleResponse(ClientRequest var1, Mono<ClientResponse> var2);
    }
}

