/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.net.URI;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationGrantRequestEntityUtils;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2RefreshTokenGrantRequestEntityConverter
implements Converter<OAuth2RefreshTokenGrantRequest, RequestEntity<?>> {
    public RequestEntity<?> convert(OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest) {
        ClientRegistration clientRegistration = refreshTokenGrantRequest.getClientRegistration();
        HttpHeaders headers = OAuth2AuthorizationGrantRequestEntityUtils.getTokenRequestHeaders(clientRegistration);
        MultiValueMap<String, String> formParameters = this.buildFormParameters(refreshTokenGrantRequest);
        URI uri = UriComponentsBuilder.fromUriString((String)clientRegistration.getProviderDetails().getTokenUri()).build().toUri();
        return new RequestEntity(formParameters, (MultiValueMap)headers, HttpMethod.POST, uri);
    }

    private MultiValueMap<String, String> buildFormParameters(OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest) {
        ClientRegistration clientRegistration = refreshTokenGrantRequest.getClientRegistration();
        LinkedMultiValueMap formParameters = new LinkedMultiValueMap();
        formParameters.add((Object)"grant_type", (Object)refreshTokenGrantRequest.getGrantType().getValue());
        formParameters.add((Object)"refresh_token", (Object)refreshTokenGrantRequest.getRefreshToken().getTokenValue());
        if (!CollectionUtils.isEmpty(refreshTokenGrantRequest.getScopes())) {
            formParameters.add((Object)"scope", (Object)StringUtils.collectionToDelimitedString(refreshTokenGrantRequest.getScopes(), (String)" "));
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            formParameters.add((Object)"client_id", (Object)clientRegistration.getClientId());
            formParameters.add((Object)"client_secret", (Object)clientRegistration.getClientSecret());
        }
        return formParameters;
    }
}

