/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class DefaultOAuth2AuthorizedClientManager
implements OAuth2AuthorizedClientManager {
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;
    private OAuth2AuthorizedClientProvider authorizedClientProvider = context -> null;
    private Function<OAuth2AuthorizeRequest, Map<String, Object>> contextAttributesMapper = new DefaultContextAttributesMapper();

    public DefaultOAuth2AuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
    }

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizeRequest authorizeRequest) {
        OAuth2AuthorizationContext.Builder contextBuilder;
        Assert.notNull((Object)authorizeRequest, (String)"authorizeRequest cannot be null");
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        OAuth2AuthorizedClient authorizedClient = authorizeRequest.getAuthorizedClient();
        Authentication principal = authorizeRequest.getPrincipal();
        HttpServletRequest servletRequest = DefaultOAuth2AuthorizedClientManager.getHttpServletRequestOrDefault(authorizeRequest.getAttributes());
        Assert.notNull((Object)servletRequest, (String)"servletRequest cannot be null");
        HttpServletResponse servletResponse = DefaultOAuth2AuthorizedClientManager.getHttpServletResponseOrDefault(authorizeRequest.getAttributes());
        Assert.notNull((Object)servletResponse, (String)"servletResponse cannot be null");
        if (authorizedClient != null) {
            contextBuilder = OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient);
        } else {
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
            Assert.notNull((Object)clientRegistration, (String)("Could not find ClientRegistration with id '" + clientRegistrationId + "'"));
            authorizedClient = this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, servletRequest);
            contextBuilder = authorizedClient != null ? OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient) : OAuth2AuthorizationContext.withClientRegistration(clientRegistration);
        }
        OAuth2AuthorizationContext authorizationContext = contextBuilder.principal(principal).attributes(attributes -> {
            Map<String, Object> contextAttributes = this.contextAttributesMapper.apply(authorizeRequest);
            if (!CollectionUtils.isEmpty(contextAttributes)) {
                attributes.putAll(contextAttributes);
            }
        }).build();
        authorizedClient = this.authorizedClientProvider.authorize(authorizationContext);
        if (authorizedClient != null) {
            this.authorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, servletRequest, servletResponse);
        } else if (authorizationContext.getAuthorizedClient() != null) {
            return authorizationContext.getAuthorizedClient();
        }
        return authorizedClient;
    }

    private static HttpServletRequest getHttpServletRequestOrDefault(Map<String, Object> attributes) {
        ServletRequestAttributes context;
        HttpServletRequest servletRequest = (HttpServletRequest)attributes.get(HttpServletRequest.class.getName());
        if (servletRequest == null && (context = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            servletRequest = context.getRequest();
        }
        return servletRequest;
    }

    private static HttpServletResponse getHttpServletResponseOrDefault(Map<String, Object> attributes) {
        ServletRequestAttributes context;
        HttpServletResponse servletResponse = (HttpServletResponse)attributes.get(HttpServletResponse.class.getName());
        if (servletResponse == null && (context = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            servletResponse = context.getResponse();
        }
        return servletResponse;
    }

    public void setAuthorizedClientProvider(OAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, (String)"authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Map<String, Object>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, (String)"contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Map<String, Object>> {
        @Override
        public Map<String, Object> apply(OAuth2AuthorizeRequest authorizeRequest) {
            Map<String, Object> contextAttributes = Collections.emptyMap();
            HttpServletRequest servletRequest = DefaultOAuth2AuthorizedClientManager.getHttpServletRequestOrDefault(authorizeRequest.getAttributes());
            String scope = servletRequest.getParameter("scope");
            if (StringUtils.hasText((String)scope)) {
                contextAttributes = new HashMap<String, Object>();
                contextAttributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, StringUtils.delimitedListToStringArray((String)scope, (String)" "));
            }
            return contextAttributes;
        }
    }
}

