/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.web.server.logout;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class OidcClientInitiatedServerLogoutSuccessHandler
implements ServerLogoutSuccessHandler {
    private final ServerRedirectStrategy redirectStrategy = new DefaultServerRedirectStrategy();
    private final RedirectServerLogoutSuccessHandler serverLogoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private URI postLogoutRedirectUri;

    public OidcClientInitiatedServerLogoutSuccessHandler(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        return Mono.just((Object)authentication).filter(OAuth2AuthenticationToken.class::isInstance).filter(token -> authentication.getPrincipal() instanceof OidcUser).map(OAuth2AuthenticationToken.class::cast).flatMap(this::endSessionEndpoint).map(endSessionEndpoint -> this.endpointUri((URI)endSessionEndpoint, authentication)).switchIfEmpty(this.serverLogoutSuccessHandler.onLogoutSuccess(exchange, authentication).then(Mono.empty())).flatMap(endpointUri -> this.redirectStrategy.sendRedirect(exchange.getExchange(), endpointUri));
    }

    private Mono<URI> endSessionEndpoint(OAuth2AuthenticationToken token) {
        String registrationId = token.getAuthorizedClientRegistrationId();
        return this.clientRegistrationRepository.findByRegistrationId(registrationId).map(ClientRegistration::getProviderDetails).map(ClientRegistration.ProviderDetails::getConfigurationMetadata).flatMap(configurationMetadata -> Mono.justOrEmpty(configurationMetadata.get("end_session_endpoint"))).map(Object::toString).map(URI::create);
    }

    private URI endpointUri(URI endSessionEndpoint, Authentication authentication) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{this.idToken(authentication)});
        if (this.postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{this.postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUri();
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    public void setPostLogoutRedirectUri(URI postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be empty");
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void setLogoutSuccessUrl(URI logoutSuccessUrl) {
        Assert.notNull((Object)logoutSuccessUrl, (String)"logoutSuccessUrl cannot be null");
        this.serverLogoutSuccessHandler.setLogoutSuccessUrl(logoutSuccessUrl);
    }
}

