/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class DefaultReactiveOAuth2UserService
implements ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private static final String MISSING_USER_INFO_URI_ERROR_CODE = "missing_user_info_uri";
    private static final String MISSING_USER_NAME_ATTRIBUTE_ERROR_CODE = "missing_user_name_attribute";
    private WebClient webClient = WebClient.create();

    @Override
    public Mono<OAuth2User> loadUser(OAuth2UserRequest userRequest) throws OAuth2AuthenticationException {
        return Mono.defer(() -> {
            Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
            String userInfoUri = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUri();
            if (!StringUtils.hasText((String)userInfoUri)) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_USER_INFO_URI_ERROR_CODE, "Missing required UserInfo Uri in UserInfoEndpoint for Client Registration: " + userRequest.getClientRegistration().getRegistrationId(), null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
            if (!StringUtils.hasText((String)userNameAttributeName)) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_USER_NAME_ATTRIBUTE_ERROR_CODE, "Missing required \"user name\" attribute name in UserInfoEndpoint for Client Registration: " + userRequest.getClientRegistration().getRegistrationId(), null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            ParameterizedTypeReference<Map<String, Object>> typeReference = new ParameterizedTypeReference<Map<String, Object>>(){};
            AuthenticationMethod authenticationMethod = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getAuthenticationMethod();
            WebClient.RequestHeadersSpec requestHeadersSpec = AuthenticationMethod.FORM.equals((Object)authenticationMethod) ? ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(userInfoUri, new Object[0])).header("Accept", new String[]{"application/json"})).header("Content-Type", new String[]{"application/x-www-form-urlencoded"})).syncBody((Object)("access_token=" + userRequest.getAccessToken().getTokenValue())) : this.webClient.get().uri(userInfoUri, new Object[0]).header("Accept", new String[]{"application/json"}).headers(headers -> headers.setBearerAuth(userRequest.getAccessToken().getTokenValue()));
            Mono userAttributes = requestHeadersSpec.retrieve().onStatus(s -> s != HttpStatus.OK, response -> DefaultReactiveOAuth2UserService.parse(response).map(userInfoErrorResponse -> {
                String description = userInfoErrorResponse.getErrorObject().getDescription();
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE, description, null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            })).bodyToMono((ParameterizedTypeReference)typeReference);
            return userAttributes.map(attrs -> {
                OAuth2UserAuthority authority = new OAuth2UserAuthority(attrs);
                HashSet<OAuth2UserAuthority> authorities = new HashSet<OAuth2UserAuthority>();
                authorities.add(authority);
                return new DefaultOAuth2User(authorities, attrs, userNameAttributeName);
            }).onErrorMap(UnknownHostException.class, t -> new AuthenticationServiceException("Unable to access the userInfoEndpoint " + userInfoUri, (Throwable)t)).onErrorMap(t -> !(t instanceof AuthenticationServiceException), t -> {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE, "An error occurred reading the UserInfo Success response: " + t.getMessage(), null);
                return new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString(), t);
            });
        });
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }

    private static Mono<UserInfoErrorResponse> parse(ClientResponse httpResponse) {
        String wwwAuth = httpResponse.headers().asHttpHeaders().getFirst("WWW-Authenticate");
        if (!StringUtils.isEmpty((Object)wwwAuth)) {
            return Mono.fromCallable(() -> UserInfoErrorResponse.parse((String)wwwAuth));
        }
        ParameterizedTypeReference<Map<String, String>> typeReference = new ParameterizedTypeReference<Map<String, String>>(){};
        return httpResponse.bodyToMono((ParameterizedTypeReference)typeReference).map(body -> new UserInfoErrorResponse(ErrorObject.parse((JSONObject)new JSONObject(body))));
    }
}

