/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication;

import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.util.CollectionUtils;

final class OidcTokenValidator {
    private static final String INVALID_ID_TOKEN_ERROR_CODE = "invalid_id_token";

    static void validateIdToken(OidcIdToken idToken, ClientRegistration clientRegistration) {
        Instant maxIssuedAt;
        Instant now;
        Instant issuedAt;
        Instant expiresAt;
        List audience;
        String subject;
        URL issuer = idToken.getIssuer();
        if (issuer == null) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if ((subject = idToken.getSubject()) == null) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if (CollectionUtils.isEmpty((Collection)(audience = idToken.getAudience()))) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if ((expiresAt = idToken.getExpiresAt()) == null) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if ((issuedAt = idToken.getIssuedAt()) == null) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if (!audience.contains(clientRegistration.getClientId())) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        String authorizedParty = idToken.getAuthorizedParty();
        if (audience.size() > 1 && authorizedParty == null) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if (authorizedParty != null && !authorizedParty.equals(clientRegistration.getClientId())) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if (!(now = Instant.now()).isBefore(expiresAt)) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
        if (issuedAt.isAfter(maxIssuedAt = now.plusSeconds(30L))) {
            OidcTokenValidator.throwInvalidIdTokenException();
        }
    }

    private static void throwInvalidIdTokenException() {
        OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE);
        throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString());
    }

    private OidcTokenValidator() {
    }
}

