/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;

public class ClientAuthorizationRequiredException
extends OAuth2AuthorizationException {
    private static final String CLIENT_AUTHORIZATION_REQUIRED_ERROR_CODE = "client_authorization_required";
    private final String clientRegistrationId;

    public ClientAuthorizationRequiredException(String clientRegistrationId) {
        super(new OAuth2Error(CLIENT_AUTHORIZATION_REQUIRED_ERROR_CODE, "Authorization required for Client Registration Id: " + clientRegistrationId, null));
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        this.clientRegistrationId = clientRegistrationId;
    }

    public String getClientRegistrationId() {
        return this.clientRegistrationId;
    }
}

