/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class InMemoryReactiveOAuth2AuthorizedClientService
implements ReactiveOAuth2AuthorizedClientService {
    private final Map<String, OAuth2AuthorizedClient> authorizedClients = new ConcurrentHashMap<String, OAuth2AuthorizedClient>();
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;

    public InMemoryReactiveOAuth2AuthorizedClientService(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    @Override
    public <T extends OAuth2AuthorizedClient> Mono<T> loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        return this.getIdentifier(clientRegistrationId, principalName).flatMap(identifier -> Mono.justOrEmpty((Object)this.authorizedClients.get(identifier)));
    }

    @Override
    public Mono<Void> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        return Mono.fromRunnable(() -> {
            String identifier = this.getIdentifier(authorizedClient.getClientRegistration(), principal.getName());
            this.authorizedClients.put(identifier, authorizedClient);
        });
    }

    @Override
    public Mono<Void> removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        return this.getIdentifier(clientRegistrationId, principalName).doOnNext(identifier -> this.authorizedClients.remove(identifier)).then(Mono.empty());
    }

    private Mono<String> getIdentifier(String clientRegistrationId, String principalName) {
        return this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).map(registration -> this.getIdentifier((ClientRegistration)registration, principalName));
    }

    private String getIdentifier(ClientRegistration registration, String principalName) {
        String identifier = "[" + registration.getRegistrationId() + "][" + principalName + "]";
        return Base64.getEncoder().encodeToString(identifier.getBytes());
    }
}

