/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.Collections;
import java.util.Map;
import org.springframework.messaging.Message;

public interface MessageMatcher<T> {
    public static final MessageMatcher<Object> ANY_MESSAGE = new MessageMatcher<Object>(){

        @Override
        public boolean matches(Message<?> message) {
            return true;
        }

        public String toString() {
            return "ANY_MESSAGE";
        }
    };

    public boolean matches(Message<? extends T> var1);

    default public MatchResult matcher(Message<? extends T> message) {
        boolean match = this.matches(message);
        return new MatchResult(match, Collections.emptyMap());
    }

    public static class MatchResult {
        private final boolean match;
        private final Map<String, String> variables;

        MatchResult(boolean match, Map<String, String> variables) {
            this.match = match;
            this.variables = variables;
        }

        public boolean isMatch() {
            return this.match;
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        public static MatchResult match() {
            return new MatchResult(true, Collections.emptyMap());
        }

        public static MatchResult match(Map<String, String> variables) {
            return new MatchResult(true, variables);
        }

        public static MatchResult notMatch() {
            return new MatchResult(false, Collections.emptyMap());
        }
    }
}

