/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.web.csrf;

import java.security.MessageDigest;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.security.messaging.web.csrf.XorCsrfTokenUtils;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;

public final class XorCsrfChannelInterceptor
implements ChannelInterceptor {
    private final MessageMatcher<Object> matcher = new SimpMessageTypeMatcher(SimpMessageType.CONNECT);

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        CsrfToken expectedToken;
        if (!this.matcher.matches(message)) {
            return message;
        }
        Map sessionAttributes = SimpMessageHeaderAccessor.getSessionAttributes((Map)message.getHeaders());
        CsrfToken csrfToken = expectedToken = sessionAttributes != null ? (CsrfToken)sessionAttributes.get(CsrfToken.class.getName()) : null;
        if (expectedToken == null) {
            throw new MissingCsrfTokenException(null);
        }
        String actualToken = SimpMessageHeaderAccessor.wrap(message).getFirstNativeHeader(expectedToken.getHeaderName());
        String actualTokenValue = XorCsrfTokenUtils.getTokenValue(actualToken, expectedToken.getToken());
        boolean csrfCheckPassed = XorCsrfChannelInterceptor.equalsConstantTime(expectedToken.getToken(), actualTokenValue);
        if (!csrfCheckPassed) {
            throw new InvalidCsrfTokenException(expectedToken, actualToken);
        }
        return message;
    }

    private static boolean equalsConstantTime(String expected, @Nullable String actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        byte[] expectedBytes = Utf8.encode((CharSequence)expected);
        byte[] actualBytes = Utf8.encode((CharSequence)actual);
        return MessageDigest.isEqual(expectedBytes, actualBytes);
    }
}

