/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.expression;

import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.messaging.Message;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.intercept.MessageAuthorizationContext;

public final class MessageAuthorizationContextSecurityExpressionHandler
implements SecurityExpressionHandler<MessageAuthorizationContext<?>> {
    private final SecurityExpressionHandler<Message<?>> delegate;

    public MessageAuthorizationContextSecurityExpressionHandler() {
        this((SecurityExpressionHandler<Message<?>>)new DefaultMessageSecurityExpressionHandler());
    }

    public MessageAuthorizationContextSecurityExpressionHandler(SecurityExpressionHandler<Message<?>> expressionHandler) {
        this.delegate = expressionHandler;
    }

    public ExpressionParser getExpressionParser() {
        return this.delegate.getExpressionParser();
    }

    public EvaluationContext createEvaluationContext(@Nullable Authentication authentication, MessageAuthorizationContext<?> message) {
        return this.createEvaluationContext(() -> authentication, message);
    }

    public EvaluationContext createEvaluationContext(Supplier<? extends @Nullable Authentication> authentication, MessageAuthorizationContext<?> message) {
        EvaluationContext context = this.delegate.createEvaluationContext(authentication, message.getMessage());
        Map<String, String> variables = message.getVariables();
        if (variables != null) {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                context.setVariable(entry.getKey(), (Object)entry.getValue());
            }
        }
        return context;
    }
}

