/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.expression;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.messaging.access.expression.MessageSecurityExpressionRoot;

public class DefaultMessageSecurityExpressionHandler<T>
extends AbstractSecurityExpressionHandler<Message<T>> {
    public EvaluationContext createEvaluationContext(Supplier<? extends @Nullable Authentication> authentication, Message<T> message) {
        MessageSecurityExpressionRoot<T> root = this.createSecurityExpressionRoot(authentication, message);
        StandardEvaluationContext ctx = new StandardEvaluationContext(root);
        BeanResolver beanResolver = this.getBeanResolver();
        if (beanResolver != null) {
            ctx.setBeanResolver(beanResolver);
        }
        return ctx;
    }

    protected SecurityExpressionOperations createSecurityExpressionRoot(@Nullable Authentication authentication, Message<T> invocation) {
        return this.createSecurityExpressionRoot(() -> authentication, invocation);
    }

    private MessageSecurityExpressionRoot<T> createSecurityExpressionRoot(Supplier<? extends Authentication> authentication, Message<T> invocation) {
        MessageSecurityExpressionRoot<T> root = new MessageSecurityExpressionRoot<T>(authentication, invocation);
        root.setAuthorizationManagerFactory(this.getAuthorizationManagerFactory());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        return root;
    }

    @Deprecated(since="7.0")
    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.getDefaultAuthorizationManagerFactory().setTrustResolver(trustResolver);
    }
}

