/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.context;

import java.util.Collection;
import java.util.Stack;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public final class SecurityContextChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    private static final ThreadLocal<Stack<SecurityContext>> originalContext = new ThreadLocal();
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private SecurityContext empty = this.securityContextHolderStrategy.createEmptyContext();
    private final String authenticationHeaderName;
    private Authentication anonymous = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public SecurityContextChannelInterceptor() {
        this("simpUser");
    }

    public SecurityContextChannelInterceptor(String authenticationHeaderName) {
        Assert.notNull((Object)authenticationHeaderName, (String)"authenticationHeaderName cannot be null");
        this.authenticationHeaderName = authenticationHeaderName;
    }

    public void setAnonymousAuthentication(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.anonymous = authentication;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        this.setup(message);
        return message;
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        this.cleanup();
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        this.setup(message);
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        this.cleanup();
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy strategy) {
        this.securityContextHolderStrategy = strategy;
        this.empty = this.securityContextHolderStrategy.createEmptyContext();
    }

    private void setup(Message<?> message) {
        SecurityContext currentContext = this.securityContextHolderStrategy.getContext();
        Stack<Object> contextStack = originalContext.get();
        if (contextStack == null) {
            contextStack = new Stack();
            originalContext.set(contextStack);
        }
        contextStack.push(currentContext);
        Object user = message.getHeaders().get((Object)this.authenticationHeaderName);
        Authentication authentication = this.getAuthentication(user);
        SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
        context.setAuthentication(authentication);
        this.securityContextHolderStrategy.setContext(context);
    }

    private Authentication getAuthentication(Object user) {
        if (user instanceof Authentication) {
            return (Authentication)user;
        }
        return this.anonymous;
    }

    private void cleanup() {
        Stack<SecurityContext> contextStack = originalContext.get();
        if (contextStack == null || contextStack.isEmpty()) {
            this.securityContextHolderStrategy.clearContext();
            originalContext.remove();
            return;
        }
        SecurityContext context = contextStack.pop();
        try {
            if (this.empty.equals(context)) {
                this.securityContextHolderStrategy.clearContext();
                originalContext.remove();
            } else {
                this.securityContextHolderStrategy.setContext(context);
            }
        }
        catch (Throwable ex) {
            this.securityContextHolderStrategy.clearContext();
        }
    }
}

