/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.util.Assert;

public class DefaultSpringSecurityContextSource
extends LdapContextSource {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String rootDn;

    public DefaultSpringSecurityContextSource(String providerUrl) {
        Assert.hasLength((String)providerUrl, (String)"An LDAP connection URL must be supplied.");
        StringTokenizer st = new StringTokenizer(providerUrl);
        ArrayList<String> urls = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String url = st.nextToken();
            String urlRootDn = LdapUtils.parseRootDnFromUrl(url);
            urls.add(url.substring(0, url.lastIndexOf(urlRootDn)));
            this.logger.info((Object)(" URL '" + url + "', root DN is '" + urlRootDn + "'"));
            if (this.rootDn == null) {
                this.rootDn = urlRootDn;
                continue;
            }
            if (this.rootDn.equals(urlRootDn)) continue;
            throw new IllegalArgumentException("Root DNs must be the same when using multiple URLs");
        }
        this.setUrls(urls.toArray(new String[urls.size()]));
        this.setBase(this.rootDn);
        this.setPooled(true);
        this.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy(){

            public void setupEnvironment(Hashtable env, String dn, String password) {
                super.setupEnvironment(env, dn, password);
                if (!DefaultSpringSecurityContextSource.this.userDn.equals(dn) && env.containsKey("com.sun.jndi.ldap.connect.pool")) {
                    DefaultSpringSecurityContextSource.this.logger.debug((Object)("Removing pooling flag for user " + dn));
                    env.remove("com.sun.jndi.ldap.connect.pool");
                }
            }
        });
    }

    public DefaultSpringSecurityContextSource(List<String> urls, String baseDn) {
        this(DefaultSpringSecurityContextSource.buildProviderUrl(urls, baseDn));
    }

    private static String buildProviderUrl(List<String> urls, String baseDn) {
        Assert.notNull((Object)baseDn, (String)"The Base DN for the LDAP server must not be null.");
        Assert.notEmpty(urls, (String)"At least one LDAP server URL must be provided.");
        String trimmedBaseDn = baseDn.trim();
        StringBuilder providerUrl = new StringBuilder();
        for (String serverUrl : urls) {
            String trimmedUrl = serverUrl.trim();
            if ("".equals(trimmedUrl)) continue;
            providerUrl.append(trimmedUrl);
            if (!trimmedUrl.endsWith("/")) {
                providerUrl.append("/");
            }
            providerUrl.append(trimmedBaseDn);
            providerUrl.append(" ");
        }
        return providerUrl.toString();
    }
}

